"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlowTimeUpdater = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
// import * as path from 'path';
const aws_cdk_lib_1 = require("aws-cdk-lib");
// import { Runtime } from 'aws-cdk-lib/aws-lambda';
// import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const api = require("./api");
const flow_time_updater_function_1 = require("./flow-time-updater-function");
class FlowTimeUpdater extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: FlowTimeUpdaterProvider.getOrCreate(this),
            resourceType: 'Custom::FlowTimeUpdater',
            properties: {
                [api.PROP_SCHEDULE]: props.schedule.expressionString,
                [api.PROP_STARTTIME]: props.startTime && props.startTime.toISOString(),
                [api.PROP_ENDTIME]: props.endTime && props.endTime.toISOString(),
            },
        });
        this.scheduleExpression = resource.getAttString(api.ATTR_SCHEDULE);
        this.startTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_STARTTIME));
        this.endTime = aws_cdk_lib_1.Token.asNumber(resource.getAtt(api.ATTR_ENDTIME));
    }
}
exports.FlowTimeUpdater = FlowTimeUpdater;
class FlowTimeUpdaterProvider extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.provider = new custom_resources_1.Provider(this, 'flow-time-provider', {
            onEventHandler: new flow_time_updater_function_1.FlowTimeUpdaterFunction(this, 'flow-time-on-event'),
        });
    }
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = 'com.amazonaws.cdk.custom-resources.flow-time-provider';
        const x = stack.node.tryFindChild(id) || new FlowTimeUpdaterProvider(stack, id);
        return x.provider.serviceToken;
    }
}
//# sourceMappingURL=data:application/json;base64,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