"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectorProfileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_appflow_1 = require("aws-cdk-lib/aws-appflow");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const connection_mode_1 = require("./connection-mode");
const appflow_permissions_manager_1 = require("../appflow-permissions-manager");
class ConnectorProfileBase extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props, connectorType) {
        super(scope, id);
        this.name = props.name ?? id;
        this.tryAddNodeDependency(this, props.key);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantKeyEncryptDecrypt(props.key);
        const resource = new aws_appflow_1.CfnConnectorProfile(this, id, {
            connectorProfileName: this.name,
            connectorLabel: connectorType.asProfileConnectorLabel,
            connectorType: connectorType.asProfileConnectorType,
            connectionMode: connection_mode_1.ConnectionMode.PUBLIC,
            kmsArn: props.key && props.key.keyArn,
            connectorProfileConfig: {
                connectorProfileCredentials: this.buildConnectorProfileCredentials(props),
                connectorProfileProperties: this.buildConnectorProfileProperties(props),
            },
        });
        this.arn = resource.attrConnectorProfileArn;
        this.credentials = aws_secretsmanager_1.Secret.fromSecretCompleteArn(scope, `${id}Credentials`, resource.attrCredentialsArn);
    }
    /**
     * @internal
     * @experimental
     */
    static _fromConnectorProfileAttributes(scope, id, attrs) {
        if (attrs.name === undefined && attrs.arn === undefined) {
            throw new Error("Either 'name' or 'arn' needs to be defined");
        }
        const { name, arn } = attrs;
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(scope, id);
                this.credentials = undefined;
                this.arn = arn ? arn : aws_cdk_lib_1.Stack.of(this).formatArn({
                    service: 'appflow',
                    resource: 'connectorprofile',
                    resourceName: name,
                    arnFormat: aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME,
                });
                this.name = name ? name : aws_cdk_lib_1.Arn.split(arn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            }
        }
        return new Import();
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.ConnectorProfileBase = ConnectorProfileBase;
_a = JSII_RTTI_SYMBOL_1;
ConnectorProfileBase[_a] = { fqn: "@cdklabs/cdk-appflow.ConnectorProfileBase", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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