import { IKey } from 'aws-cdk-lib/aws-kms';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
/**
 * see: https://docs.aws.amazon.com/appflow/latest/userguide/salesforce.html#salesforce-setup
 * @internal
 */
export declare class AppFlowPermissionsManager {
    /**
     * Singleton instance of the AppFlowPermissionsManager
     */
    static instance(): AppFlowPermissionsManager;
    private readonly principal;
    private readonly tokenPermissions;
    private readonly writeS3BucketActions;
    private readonly readS3BucketActions;
    private readonly encryptKMSKeyActions;
    private readonly decryptKMSKeyActions;
    private readonly readSMSecretActions;
    private constructor();
    private getActionsFor;
    grantBucketWrite(bucket?: IBucket): void;
    grantBucketRead(bucket?: IBucket): void;
    grantBucketReadWrite(bucket?: IBucket): void;
    grantKeyEncryptDecrypt(key?: IKey): void;
    grantKeyEncrypt(key?: IKey): void;
    grantKeyDecrypt(key?: IKey): void;
    grantSecretRead(secret?: ISecret): void;
}
