# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class SetDomainConfigRequest(JDCloudRequest):
    """
    更新域名配置
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(SetDomainConfigRequest, self).__init__(
            '/domain/{domain}/config', 'POST', header, version)
        self.parameters = parameters


class SetDomainConfigParameters(object):

    def __init__(self,domain, ):
        """
        :param domain: 用户域名
        """

        self.domain = domain
        self.httpType = None
        self.backSourceType = None
        self.jumpType = None
        self.jcdnTimeAnti = None
        self.hdrCtrl = None
        self.toutiaoHeader = None

    def setHttpType(self, httpType):
        """
        :param httpType: (Optional) http类型,只能为http或者https
        """
        self.httpType = httpType

    def setBackSourceType(self, backSourceType):
        """
        :param backSourceType: (Optional) 回源类型
        """
        self.backSourceType = backSourceType

    def setJumpType(self, jumpType):
        """
        :param jumpType: (Optional) 有三种类型：default、http、https
        """
        self.jumpType = jumpType

    def setJcdnTimeAnti(self, jcdnTimeAnti):
        """
        :param jcdnTimeAnti: (Optional) dash鉴权相关配置
        """
        self.jcdnTimeAnti = jcdnTimeAnti

    def setHdrCtrl(self, hdrCtrl):
        """
        :param hdrCtrl: (Optional) 回源鉴权相关配置
        """
        self.hdrCtrl = hdrCtrl

    def setToutiaoHeader(self, toutiaoHeader):
        """
        :param toutiaoHeader: (Optional) 头条header配置
        """
        self.toutiaoHeader = toutiaoHeader

