import { Reference } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for a lambda function provider
 */
export interface LambdaFunctionProviderProps {
    /**
     * The handler to use for the lambda function
     *
     * @default index.handler
     */
    readonly handler?: string;
}
/**
 * Properties for defining an AssertionsProvider
 */
export interface AssertionsProviderProps extends LambdaFunctionProviderProps {
    /**
     * This determines the uniqueness of each AssertionsProvider.
     * You should only need to provide something different here if you
     * _know_ that you need a separate provider
     *
     * @default - the default uuid is used
     */
    readonly uuid?: string;
}
/**
 * Represents an assertions provider. The creates a singletone
 * Lambda Function that will create a single function per stack
 * that serves as the custom resource provider for the various
 * assertion providers
 */
export declare class AssertionsProvider extends Construct {
    /**
     * The ARN of the lambda function which can be used
     * as a serviceToken to a CustomResource
     */
    readonly serviceToken: string;
    /**
     * A reference to the provider Lambda Function
     * execution Role ARN
     */
    readonly handlerRoleArn: Reference;
    private readonly handler;
    constructor(scope: Construct, id: string, props?: AssertionsProviderProps);
    /**
     * Encode an object so it can be passed
     * as custom resource parameters. Custom resources will convert
     * all input parameters to strings so we encode non-strings here
     * so we can then decode them correctly in the provider function
     */
    encode(obj: any): any;
    /**
     * Create a policy statement from a specific api call
     */
    addPolicyStatementFromSdkCall(service: string, api: string, resources?: string[]): void;
    /**
     * Add an IAM policy statement to the inline policy of the
     * lambdas function's role
     *
     * **Please note**: this is a direct IAM JSON policy blob, *not* a `iam.PolicyStatement`
     * object like you will see in the rest of the CDK.
     *
     *
     * @example
     * declare const provider: AssertionsProvider;
     * provider.addToRolePolicy({
     *   Effect: 'Allow',
     *   Action: ['s3:GetObject'],
     *   Resource: ['*'],
     * });
     */
    addToRolePolicy(statement: any): void;
    /**
     * Grant a principal access to invoke the assertion provider
     * lambda function
     *
     * @param principalArn the ARN of the principal that should be given
     *  permission to invoke the assertion provider
     */
    grantInvoke(principalArn: string): void;
}
