"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const hash_1 = require("./private/hash");
const providers_1 = require("./providers");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_EqualsAssertionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EqualsAssertion);
            }
            throw error;
        }
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.actual.result,
            expected: props.expected.result,
            failDeployment: props.failDeployment,
        };
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties: {
                ...properties,
                salt: Date.now().toString(),
            },
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
        new aws_cdk_lib_1.CfnOutput(this, 'AssertionResults', {
            value: this.result,
        }).overrideLogicalId(`AssertionResults${id}${hash_1.md5hash({ actual: props.actual.result, expected: props.expected.result })}`);
    }
}
exports.EqualsAssertion = EqualsAssertion;
_a = JSII_RTTI_SYMBOL_1;
EqualsAssertion[_a] = { fqn: "@aws-cdk/integ-tests-alpha.EqualsAssertion", version: "2.63.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNzZXJ0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFzc2VydGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsNkNBQXdEO0FBQ3hELDJDQUF1QztBQUV2Qyx5Q0FBeUM7QUFDekMsMkNBQXlGO0FBNEJ6Rjs7O0dBR0c7QUFDSCxNQUFhLGVBQWdCLFNBQVEsc0JBQVM7SUFNNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjtRQUNuRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBUFIsZUFBZTs7OztRQVN4QixNQUFNLGlCQUFpQixHQUFHLElBQUksOEJBQWtCLENBQUMsSUFBSSxFQUFFLG1CQUFtQixDQUFDLENBQUM7UUFDNUUsTUFBTSxVQUFVLEdBQXFCO1lBQ25DLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLE1BQU07WUFDM0IsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsTUFBTTtZQUMvQixjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7U0FDckMsQ0FBQztRQUNGLE1BQU0sUUFBUSxHQUFHLElBQUksNEJBQWMsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO1lBQ25ELFlBQVksRUFBRSxpQkFBaUIsQ0FBQyxZQUFZO1lBQzVDLFVBQVUsRUFBRTtnQkFDVixHQUFHLFVBQVU7Z0JBQ2IsSUFBSSxFQUFFLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxRQUFRLEVBQUU7YUFDNUI7WUFDRCxZQUFZLEVBQUUsZ0NBQW9CO1NBQ25DLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUU1QyxJQUFJLHVCQUFTLENBQUMsSUFBSSxFQUFFLGtCQUFrQixFQUFFO1lBQ3RDLEtBQUssRUFBRSxJQUFJLENBQUMsTUFBTTtTQUNuQixDQUFDLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxjQUFPLENBQUMsRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7S0FDM0g7O0FBNUJILDBDQTZCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEN1c3RvbVJlc291cmNlLCBDZm5PdXRwdXQgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEV4cGVjdGVkUmVzdWx0LCBBY3R1YWxSZXN1bHQgfSBmcm9tICcuL2NvbW1vbic7XG5pbXBvcnQgeyBtZDVoYXNoIH0gZnJvbSAnLi9wcml2YXRlL2hhc2gnO1xuaW1wb3J0IHsgQXNzZXJ0aW9uUmVxdWVzdCwgQXNzZXJ0aW9uc1Byb3ZpZGVyLCBBU1NFUlRfUkVTT1VSQ0VfVFlQRSB9IGZyb20gJy4vcHJvdmlkZXJzJztcblxuLyoqXG4gKiBPcHRpb25zIGZvciBhbiBFcXVhbHNBc3NlcnRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFcXVhbHNBc3NlcnRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgYWN0dWFsIHJlc3VsdHMgdG8gY29tcGFyZVxuICAgKi9cbiAgcmVhZG9ubHkgYWN0dWFsOiBBY3R1YWxSZXN1bHQ7XG5cbiAgLyoqXG4gICAqIFRoZSBleHBlY3RlZCByZXN1bHQgdG8gYXNzZXJ0XG4gICAqL1xuICByZWFkb25seSBleHBlY3RlZDogRXhwZWN0ZWRSZXN1bHQ7XG5cbiAgLyoqXG4gICAqIFNldCB0aGlzIHRvIHRydWUgaWYgYSBmYWlsZWQgYXNzZXJ0aW9uIHNob3VsZFxuICAgKiByZXN1bHQgaW4gYSBDbG91ZEZvcm1hdGlvbiBkZXBsb3ltZW50IGZhaWx1cmVcbiAgICpcbiAgICogVGhpcyBpcyBvbmx5IG5lY2Vzc2FyeSBpZiBhc3NlcnRpb25zIGFyZSBiZWluZ1xuICAgKiBleGVjdXRlZCBvdXRzaWRlIG9mIGBpbnRlZy1ydW5uZXJgLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZmFpbERlcGxveW1lbnQ/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIENvbnN0cnVjdCB0aGF0IGNyZWF0ZXMgYSBDdXN0b21SZXNvdXJjZSB0byBhc3NlcnQgdGhhdCB0d29cbiAqIHZhbHVlcyBhcmUgZXF1YWxcbiAqL1xuZXhwb3J0IGNsYXNzIEVxdWFsc0Fzc2VydGlvbiBleHRlbmRzIENvbnN0cnVjdCB7XG4gIC8qKlxuICAgKiBUaGUgcmVzdWx0IG9mIHRoZSBhc3NlcnRpb25cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSByZXN1bHQ6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRXF1YWxzQXNzZXJ0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgYXNzZXJ0aW9uUHJvdmlkZXIgPSBuZXcgQXNzZXJ0aW9uc1Byb3ZpZGVyKHRoaXMsICdBc3NlcnRpb25Qcm92aWRlcicpO1xuICAgIGNvbnN0IHByb3BlcnRpZXM6IEFzc2VydGlvblJlcXVlc3QgPSB7XG4gICAgICBhY3R1YWw6IHByb3BzLmFjdHVhbC5yZXN1bHQsXG4gICAgICBleHBlY3RlZDogcHJvcHMuZXhwZWN0ZWQucmVzdWx0LFxuICAgICAgZmFpbERlcGxveW1lbnQ6IHByb3BzLmZhaWxEZXBsb3ltZW50LFxuICAgIH07XG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0RlZmF1bHQnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW46IGFzc2VydGlvblByb3ZpZGVyLnNlcnZpY2VUb2tlbixcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgLi4ucHJvcGVydGllcyxcbiAgICAgICAgc2FsdDogRGF0ZS5ub3coKS50b1N0cmluZygpLCAvLyBhbHdheXMgdXBkYXRlLFxuICAgICAgfSxcbiAgICAgIHJlc291cmNlVHlwZTogQVNTRVJUX1JFU09VUkNFX1RZUEUsXG4gICAgfSk7XG4gICAgdGhpcy5yZXN1bHQgPSByZXNvdXJjZS5nZXRBdHRTdHJpbmcoJ2RhdGEnKTtcblxuICAgIG5ldyBDZm5PdXRwdXQodGhpcywgJ0Fzc2VydGlvblJlc3VsdHMnLCB7XG4gICAgICB2YWx1ZTogdGhpcy5yZXN1bHQsXG4gICAgfSkub3ZlcnJpZGVMb2dpY2FsSWQoYEFzc2VydGlvblJlc3VsdHMke2lkfSR7bWQ1aGFzaCh7IGFjdHVhbDogcHJvcHMuYWN0dWFsLnJlc3VsdCwgZXhwZWN0ZWQ6IHByb3BzLmV4cGVjdGVkLnJlc3VsdCB9KX1gKTtcbiAgfVxufVxuIl19