## About eUVM

eUVM is an opensource implementation of IEEE UVM-1800.2-2020 standard in the D Programming Language.

## About the RISCV-DV eUVM port

The RISCV-DV eUVM port is a line-by-line translation of the RISCV-DV SystemVerilog implementation. Except for functional coverage (a work in progress), all other RISCV-DV features have been implemented in eUVM port.

## Downloading and Installing eUVM

If you want to build/use the eUVM port, you need an eUVM installation. Please follow the instructions on https://github.com/coverify/euvm/releases to install and setup eUVM.

## Building eUVM port of RISCV-DV

A makefile to build and run the eUVM port is available in the euvm/build folder. To build the code, use the following commands (assuming bash shell):

```bash
cd euvm/build
make -j $(nproc)
```

Makefile builds RISCV-DV for RV64IMC architecture by default. If you want to build for an alternate architecture, you need to pass that to make command as TARGET parameter:

```bash
cd euvm/build
make clean
make -j $(nproc) TARGET=RV64IMCB
```

Remember to make clean before switching to a new target.

## Generating RISCV-DV tests

```bash
cd euvm/build
make run
```

You can change the number of instructions to be generated by passsing INSTRCOUNT parameter to the make command:

```bash
make run INSTRCOUNT=1000000
```
