from .components import (
    render_entity,
    render_infrastructure_repository,
    render_infrastructure_service,
    render_interactor,
    render_mediator,
    render_repository_interface,
    render_service_interface,
    render_web_package_init,
    # CQRS templates
    render_cqrs_handler,
    render_cqrs_command,
    render_cqrs_query,
    render_cqrs_response,
    # DDD templates
    render_aggregate,
    render_value_object,
    render_context_init,
    # New Vega Web functions
    render_vega_app,
    render_vega_routes_init,
    render_vega_health_route,
    render_vega_user_route,
    render_vega_dependencies,
    render_vega_main,
    render_vega_project_main,
    render_vega_router,
    render_vega_middleware,
    render_vega_routes_init_autodiscovery,
    # Backward compatibility (deprecated)
    render_fastapi_app,
    render_fastapi_routes_init,
    render_fastapi_health_route,
    render_fastapi_user_route,
    render_fastapi_dependencies,
    render_fastapi_main,
    render_fastapi_project_main,
    render_fastapi_router,
    render_fastapi_middleware,
    render_fastapi_routes_init_autodiscovery,
    # Common
    render_standard_main,
    render_pydantic_models_init,
    render_pydantic_user_models,
    render_database_manager,
    render_alembic_ini,
    render_alembic_env,
    render_alembic_script_mako,
    render_sqlalchemy_model,
    render_cli_command,
    render_cli_command_simple,
    render_cli_commands_init,
    render_event,
    render_event_handler,
    render_events_init,
    render_listener,
)
from .loader import render_template

__all__ = [
    "render_entity",
    "render_repository_interface",
    "render_service_interface",
    "render_interactor",
    "render_mediator",
    "render_infrastructure_repository",
    "render_infrastructure_service",
    "render_web_package_init",
    # CQRS
    "render_cqrs_handler",
    "render_cqrs_command",
    "render_cqrs_query",
    "render_cqrs_response",
    # DDD
    "render_aggregate",
    "render_value_object",
    "render_context_init",
    # Vega Web
    "render_vega_app",
    "render_vega_routes_init",
    "render_vega_health_route",
    "render_vega_user_route",
    "render_vega_dependencies",
    "render_vega_main",
    "render_vega_project_main",
    "render_vega_router",
    "render_vega_middleware",
    "render_vega_routes_init_autodiscovery",
    # Backward compat (deprecated)
    "render_fastapi_app",
    "render_fastapi_routes_init",
    "render_fastapi_health_route",
    "render_fastapi_user_route",
    "render_fastapi_dependencies",
    "render_fastapi_main",
    "render_fastapi_project_main",
    "render_fastapi_router",
    "render_fastapi_middleware",
    "render_fastapi_routes_init_autodiscovery",
    # Common
    "render_standard_main",
    "render_pydantic_models_init",
    "render_pydantic_user_models",
    "render_database_manager",
    "render_alembic_ini",
    "render_alembic_env",
    "render_alembic_script_mako",
    "render_sqlalchemy_model",
    "render_cli_command",
    "render_cli_command_simple",
    "render_cli_commands_init",
    "render_event",
    "render_event_handler",
    "render_events_init",
    "render_listener",
    "render_template",
]
