/*
 * Decompiled with CFR 0.152.
 */
package fortran.ofp.parser.java;

import fortran.ofp.parser.java.CodeLocation;
import org.antlr.runtime.Token;
import org.w3c.dom.Element;

public class CodeBounds {
    protected static String Y_MIN = "line_begin";
    protected static String X_MIN = "col_begin";
    protected static String Y_MAX = "line_end";
    protected static String X_MAX = "col_end";
    public CodeLocation begin;
    public CodeLocation end;

    public CodeBounds() {
        this.begin = null;
        this.end = null;
    }

    public CodeBounds(int beginLine, int beginCol, int endLine, int endCol) {
        this.begin = new CodeLocation(beginLine, beginCol);
        this.end = new CodeLocation(endLine, endCol);
    }

    public CodeBounds(Element context) {
        Integer colEnd;
        Integer colBegin;
        Integer lineBegin = context.hasAttribute(Y_MIN) ? Integer.valueOf(context.getAttribute(Y_MIN)) : null;
        Integer n = colBegin = context.hasAttribute(X_MIN) ? Integer.valueOf(context.getAttribute(X_MIN)) : null;
        if (lineBegin == null && colBegin == null) {
            this.begin = null;
        } else {
            if (lineBegin == null || colBegin == null) {
                throw new IllegalArgumentException("the implementation of this method is all-or-nothing");
            }
            this.begin = new CodeLocation(lineBegin, colBegin);
        }
        Integer lineEnd = context.hasAttribute(Y_MAX) ? Integer.valueOf(context.getAttribute(Y_MAX)) : null;
        Integer n2 = colEnd = context.hasAttribute(X_MAX) ? Integer.valueOf(context.getAttribute(X_MAX)) : null;
        if (lineEnd == null && colEnd == null) {
            this.begin = null;
        } else {
            if (lineEnd == null || colEnd == null) {
                throw new IllegalArgumentException("the implementation of this method is all-or-nothing");
            }
            this.end = new CodeLocation(lineEnd, colEnd);
        }
    }

    public CodeBounds(Token token) {
        Integer line = token.getLine();
        Integer colBegin = token.getCharPositionInLine();
        Integer colEnd = colBegin + token.getText().length();
        this.begin = new CodeLocation(line, colBegin);
        this.end = new CodeLocation(line, colEnd);
    }

    public void extend(CodeLocation loc) {
        boolean updateColEnd;
        if (loc == null) {
            throw new IllegalArgumentException("the implementation of this method is all-or-nothing");
        }
        if (this.begin == null && this.end == null) {
            this.begin = new CodeLocation(loc.line, loc.col);
            this.end = new CodeLocation(loc.line, loc.col);
            return;
        }
        if (this.begin == null || this.end == null) {
            throw new IllegalArgumentException("the implementation of this method is all-or-nothing");
        }
        boolean updateLineBegin = loc.line < this.begin.line;
        boolean updateColBegin = updateLineBegin || loc.line == this.begin.line && loc.col < this.begin.col;
        boolean updateLineEnd = loc.line > this.end.line;
        boolean bl = updateColEnd = updateLineEnd || loc.line == this.end.line && loc.col > this.end.col;
        if (updateLineBegin) {
            this.begin.line = loc.line;
        }
        if (updateColBegin) {
            this.begin.col = loc.col;
        }
        if (updateLineEnd) {
            this.end.line = loc.line;
        }
        if (updateColEnd) {
            this.end.col = loc.col;
        }
    }

    public void extend(Token token) {
        CodeBounds bounds = new CodeBounds(token);
        this.extend(bounds.begin);
        this.extend(bounds.end);
    }

    public void persist(Element context) {
        context.setAttribute(Y_MIN, Integer.toString(this.begin.line));
        context.setAttribute(X_MIN, Integer.toString(this.begin.col));
        context.setAttribute(Y_MAX, Integer.toString(this.end.line));
        context.setAttribute(X_MAX, Integer.toString(this.end.col));
    }

    public String toString() {
        return this.begin + "~" + this.end;
    }
}

