/*
 * Decompiled with CFR 0.152.
 */
package fortran.ofp;

import fortran.ofp.XmlPrinterArgsParser;
import fortran.ofp.parser.java.CodeBounds;
import fortran.ofp.parser.java.FortranParserActionPrint;
import fortran.ofp.parser.java.IFortranParser;
import fortran.ofp.parser.java.TokensList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.antlr.runtime.Token;
import org.apache.commons.cli.CommandLine;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XMLPrinterBase
extends FortranParserActionPrint {
    private CommandLine cmd;
    protected int verbosity;
    protected Document doc;
    protected Element root;
    protected Element context = null;
    public static ArrayList<String> tokenLocationsWhitelist = new ArrayList<String>(Arrays.asList("file", "members", "body", "specification"));

    public XMLPrinterBase(String[] args, IFortranParser parser, String filename) {
        super(args, parser, filename);
        this.cmd = new XmlPrinterArgsParser().parse(args);
        this.verbosity = Integer.parseInt(this.cmd.getOptionValue("verbosity", "100"));
        if (this.verbosity >= 100) {
            this.setVerbose(true);
            this.setPrintKeywords(true);
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            this.root = this.contextOpen("ofp");
            this.setAttribute("version", "0.8.4");
            this.doc.appendChild(this.root);
        }
        catch (Exception error) {
            error.printStackTrace();
            System.exit(1);
        }
    }

    protected Element contextOpen(String name) {
        Element new_context = this.doc.createElement(name);
        if (this.context != null) {
            this.context.appendChild(new_context);
        }
        this.context = new_context;
        return this.context;
    }

    protected ArrayList<Element> contextHierarchy(Element context) {
        ArrayList<Element> hierarchy = new ArrayList<Element>();
        hierarchy.add(context);
        for (Element found = context; found != this.root && found.getParentNode() != null; found = (Element)found.getParentNode()) {
            hierarchy.add(found);
        }
        return hierarchy;
    }

    protected ArrayList<Element> contextHierarchy() {
        return this.contextHierarchy(this.context);
    }

    protected ArrayList<String> contextNameHierarchy(Element context) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element found : this.contextHierarchy(context)) {
            names.add(found.getTagName());
        }
        return names;
    }

    protected ArrayList<String> contextNameHierarchy() {
        return this.contextNameHierarchy(this.context);
    }

    protected Element contextTryFind(String ... names) {
        if (this.context == null) {
            return null;
        }
        Element found = this.context;
        List<String> names_list = Arrays.asList(names);
        while (!names_list.contains(found.getTagName())) {
            if (found == this.root) {
                return null;
            }
            found = (Element)found.getParentNode();
        }
        return found;
    }

    protected Element contextFind(String ... names) {
        if (this.context == null) {
            throw new NullPointerException("No open contexts, so " + Arrays.toString(names) + " cannot be found.");
        }
        Element found = this.contextTryFind(names);
        if (found != null) {
            return found;
        }
        System.err.println("Cannot find any context of " + Arrays.toString(names) + " among open contexts.");
        System.err.println("Current context hierarchy (innermost first) is:");
        for (String name : this.contextNameHierarchy()) {
            System.err.println("  " + name);
        }
        this.cleanUpAfterError();
        return null;
    }

    protected void contextRename(Element context, String toName) {
        this.doc.renameNode(context, null, toName);
    }

    protected void contextRename(String toName) {
        this.contextRename(this.context, this.context.getTagName(), toName);
    }

    protected void contextRename(Element context, String fromName, String toName) {
        if (context.getTagName() != fromName) {
            this.cleanUpAfterError("Cannot rename current context from '" + fromName + "' to '" + toName + "' because its name is '" + context.getTagName() + "'.");
        }
        this.contextRename(context, toName);
    }

    protected void contextRename(String fromName, String toName) {
        this.contextRename(this.context, fromName, toName);
    }

    protected void contextClose(Element context) {
        if (context == this.root) {
            this.cleanUpAfterError("Cannot close given context because it is root node of the document.");
        }
        this.context = (Element)context.getParentNode();
    }

    protected void contextClose() {
        this.contextClose(this.context);
    }

    protected void contextClose(String ... names) {
        this.contextClose(this.contextFind(names));
    }

    protected void contextCloseAllInner(String ... names) {
        this.context = this.contextFind(names);
    }

    protected ArrayList<Attr> contextAttributes(Element context) {
        NamedNodeMap attributesMap = context.getAttributes();
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            attributes.add((Attr)attributesMap.item(i));
        }
        return attributes;
    }

    protected ArrayList<Attr> contextAttributes() {
        return this.contextAttributes(this.context);
    }

    protected ArrayList<Element> contextNodes(Element context, int beginIndex, int count) {
        NodeList nodeList = context.getChildNodes();
        int nodeListLength = nodeList.getLength();
        ArrayList<Element> nodes = new ArrayList<Element>();
        if (count == 0 && nodeListLength == 0) {
            return nodes;
        }
        if (beginIndex < 0) {
            beginIndex = nodeListLength + beginIndex;
        }
        if (beginIndex < 0 || beginIndex >= nodeListLength) {
            this.cleanUpAfterError("starting index " + beginIndex + " out of bounds [" + 0 + ", " + nodeListLength + ")");
        }
        if (count == 0) {
            count = nodeListLength - beginIndex;
        }
        if (count < 0) {
            this.cleanUpAfterError("attemted to return " + count + " number of nodes");
        }
        int endIndex = beginIndex + count;
        for (int i = beginIndex; i < endIndex; ++i) {
            nodes.add((Element)nodeList.item(i));
        }
        return nodes;
    }

    protected ArrayList<Element> contextNodes(Element context) {
        return this.contextNodes(context, 0, 0);
    }

    protected ArrayList<Element> contextNodes(int beginIndex, int count) {
        return this.contextNodes(this.context, beginIndex, count);
    }

    protected ArrayList<Element> contextNodes() {
        return this.contextNodes(this.context, 0, 0);
    }

    protected int contextNodesCount(Element context) {
        return context.getChildNodes().getLength();
    }

    protected int contextNodesCount() {
        return this.contextNodesCount(this.context);
    }

    protected Element contextNode(Element context, int index) {
        return this.contextNodes(context, index, 1).get(0);
    }

    protected Element contextNode(int index) {
        return this.contextNode(this.context, index);
    }

    protected String contextString(Element context) {
        if (context == null) {
            return "context is null";
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Element node : this.contextNodes(context)) {
            names.add(node.getTagName());
        }
        return "context: " + context.getTagName() + "\n" + "  attributes: " + this.contextAttributes(context) + "\n" + "  sub-contexts: " + names;
    }

    protected void contextPrint(Element context) {
        if (context == null) {
            System.err.println("context is null");
            return;
        }
        System.err.println("context: " + context.getTagName());
        System.err.println("  attributes: " + this.contextAttributes(context));
        ArrayList<String> names = new ArrayList<String>();
        for (Element node : this.contextNodes(context)) {
            names.add(node.getTagName());
        }
        System.err.println("  sub-contexts: " + names);
    }

    protected Attr getAttribute(String name, Element context) {
        return (Attr)context.getAttributes().getNamedItem(name);
    }

    protected Attr getAttribute(String name) {
        return this.getAttribute(name, this.context);
    }

    protected void setAttribute(String name, Object value, Element context) {
        String valueString = null;
        if (value == null) {
            valueString = "";
        } else if (value instanceof Token) {
            Token token = (Token)value;
            valueString = token.getText();
            if (this.verbosity >= 100) {
                CodeBounds bounds = new CodeBounds(context);
                bounds.extend(token);
                bounds.persist(context);
            }
        } else {
            valueString = value.toString();
        }
        context.setAttribute(name, valueString);
    }

    protected void setAttribute(String name, Object value, String ... names) {
        this.setAttribute(name, value, this.contextFind(names));
    }

    protected void setAttribute(String name, Object value) {
        this.setAttribute(name, value, this.context);
    }

    public Element findContext(Element context, int line, int col) {
        for (Element node : this.contextNodes(context)) {
            Element containingNode = this.findContext(node, line, col);
            if (containingNode == null) continue;
            return containingNode;
        }
        CodeBounds bounds = new CodeBounds(context);
        if (bounds.begin == null || bounds.end == null) {
            return null;
        }
        if (line < bounds.begin.line || line > bounds.end.line) {
            return null;
        }
        if (line > bounds.begin.line && line < bounds.end.line) {
            return context;
        }
        if (line == bounds.begin.line) {
            return col >= bounds.begin.col ? context : null;
        }
        if (line == bounds.end.line) {
            return col <= bounds.end.col ? context : null;
        }
        throw new RuntimeException();
    }

    public int findPosition(Element context, int line, int col) {
        int index = -1;
        for (Element node : this.contextNodes(context)) {
            CodeBounds bounds = new CodeBounds(node);
            ++index;
            if (bounds.begin == null || bounds.end == null) continue;
            if (line < bounds.begin.line) {
                return index;
            }
            if (line > bounds.end.line) continue;
            if (line == bounds.begin.line && col < bounds.begin.col) {
                return index;
            }
            if (col > bounds.end.col) continue;
            throw new RuntimeException("looking for (" + line + "," + col + ")" + " within bounds " + bounds + "\n" + "of " + this.contextString(node) + "\n" + "subnode of " + this.contextString(context));
        }
        return this.contextNodesCount(context);
    }

    protected void propagateBounds(Element context) {
        ArrayList<Element> nodes = this.contextNodes(context);
        for (Element node : nodes) {
            this.propagateBounds(node);
            if (context == this.root || node.getNodeName().equals("file")) continue;
            CodeBounds bounds = new CodeBounds(node);
            if (bounds.begin == null) continue;
            CodeBounds rootBounds = new CodeBounds(context);
            rootBounds.extend(bounds.begin);
            rootBounds.extend(bounds.end);
            rootBounds.persist(context);
        }
    }

    protected void moveTo(Element targetContext, Integer targetIndex, Element element) {
        if (targetContext == element) {
            this.cleanUpAfterError("Cannot move " + element + " to itself.");
        }
        try {
            element.getParentNode().removeChild(element);
            boolean insert = false;
            if (targetIndex != null) {
                if (targetIndex < 0) {
                    if ((targetIndex = Integer.valueOf(targetIndex + 1)) < 0) {
                        insert = true;
                    }
                } else {
                    insert = true;
                }
            }
            if (insert) {
                targetContext.insertBefore(element, this.contextNode(targetContext, targetIndex));
            } else {
                targetContext.appendChild(element);
            }
        }
        catch (DOMException error) {
            System.err.println("Cannot move " + element + " to " + targetContext + ".");
            this.contextPrint(element);
            System.err.println(this.contextNameHierarchy(element));
            this.contextPrint(targetContext);
            System.err.println(this.contextNameHierarchy(targetContext));
            this.cleanUpAfterError(error);
        }
    }

    protected void moveTo(Element targetContext, Element element) {
        this.moveTo(targetContext, null, element);
    }

    protected void moveHere(Integer targetIndex, Element element) {
        this.moveTo(this.context, targetIndex, element);
    }

    protected void moveHere(Element element) {
        this.moveTo(this.context, null, element);
    }

    protected void moveTo(Element targetContext, Integer targetIndex, ArrayList<Element> elements) {
        for (Element element : elements) {
            this.moveTo(targetContext, targetIndex, element);
        }
    }

    protected void moveTo(Element targetContext, ArrayList<Element> elements) {
        this.moveTo(targetContext, null, elements);
    }

    protected void moveTo(Integer targetIndex, ArrayList<Element> elements) {
        this.moveTo(this.context, targetIndex, elements);
    }

    protected void moveHere(ArrayList<Element> elements) {
        this.moveTo(this.context, null, elements);
    }

    protected void printRuleHeader(int rule, String name, String addendum) {
        this.contextOpen(name);
        this.setAttribute("rule", rule);
        if (addendum.length() > 0) {
            this.setAttribute("addendum", addendum);
        }
    }

    protected void printRuleTrailer() {
        this.contextClose();
    }

    protected void printParameter(Object param, String name) {
        this.setAttribute(name, param);
    }

    protected void printParameter(Token param, String name) {
        this.setAttribute(name, param);
    }

    protected void printTokens(Token ... tokens) {
        for (Token token : tokens) {
            if (token == null) {
                System.err.println("token is null");
                continue;
            }
            int line = token.getLine();
            int colBegin = token.getCharPositionInLine();
            String text = token.getText();
            int colEnd = colBegin + text.length();
            System.err.println(this.filename + "@" + line + ":" + colBegin + "~" + colEnd + ": \"" + text + "\"");
        }
    }

    protected void insertTokens(Element context, int tokenType, String tokenContextName, String tokenTextAttributeName) throws IOException {
        TokensList tokens = new TokensList(new File(this.filename), tokenType);
        this.insertTokens(context, tokens, tokenContextName, tokenTextAttributeName);
    }

    protected void insertTokens(Element context, ArrayList<Token> tokens, String tokenContextName, String tokenTextAttributeName) {
        for (Token token : tokens) {
            this.insertToken(context, token, tokenContextName, tokenTextAttributeName);
        }
    }

    protected void insertToken(Element context, Token token, String tokenContextName, String tokenTextAttributeName) {
        TokenTarget target = this.findTarget(context, token);
        Element tokenNode = this.contextOpen(tokenContextName);
        this.setAttribute(tokenTextAttributeName, token.getText());
        CodeBounds bounds = new CodeBounds(token);
        bounds.persist(tokenNode);
        this.contextClose();
        tokenNode.getParentNode().removeChild(tokenNode);
        if (target.index < this.contextNodesCount(target.element)) {
            target.element.insertBefore(tokenNode, this.contextNode(target.element, target.index));
        } else if (target.index == this.contextNodesCount(target.element)) {
            target.element.appendChild(tokenNode);
        } else {
            throw new IllegalArgumentException("location within target is invalid");
        }
        this.propagateBounds(target.element);
    }

    private TokenTarget findTarget(Element context, Token token) {
        int col_begin;
        int line = token.getLine();
        Element target = this.findContext(context, line, col_begin = token.getCharPositionInLine());
        if (target == null) {
            target = this.contextNode(this.root, 0);
        }
        int targetIndex = this.findPosition(target, line, col_begin);
        return this.refineTarget(token, target, targetIndex);
    }

    private TokenTarget refineTarget(Token token, Element target, int targetIndex) {
        Element afterTarget;
        Element beforeTarget;
        if (this.contextNodesCount(target) == 0) {
            ArrayList<Element> hierarchy = this.contextHierarchy(target);
            hierarchy.remove(0);
            for (Element parent : hierarchy) {
                ArrayList<Element> parentNodes = this.contextNodes(parent);
                int indexInParent = parentNodes.indexOf(target);
                target = parent;
                targetIndex = indexInParent + 1;
                if (!tokenLocationsWhitelist.contains(target.getNodeName())) continue;
                break;
            }
            if (!tokenLocationsWhitelist.contains(target.getNodeName())) {
                throw new IllegalArgumentException("didn't find good candidate to adjust token " + token + " location in hierarchy " + hierarchy);
            }
        }
        boolean updated = false;
        if (targetIndex > 0 && (beforeTarget = this.contextNode(target, targetIndex - 1)).getNodeName().equals("body")) {
            target = beforeTarget;
            targetIndex = this.contextNodesCount(beforeTarget);
            updated = true;
        }
        if (!updated && targetIndex < this.contextNodesCount(target) - 1 && (afterTarget = this.contextNode(target, targetIndex)).getNodeName().equals("body")) {
            target = afterTarget;
            targetIndex = 0;
            updated = true;
        }
        return new TokenTarget(target, targetIndex);
    }

    public void persist() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = this.cmd.hasOption("output") ? new StreamResult(new File(this.cmd.getOptionValue("output"))) : new StreamResult(System.out);
        transformer.transform(source, result);
    }

    public void cleanUpAfterError(String comment, Exception error) {
        if (comment != null) {
            System.err.println(comment);
        }
        new RuntimeException("Aborting construction of the AST.", error).printStackTrace();
        this.cleanUp();
        System.exit(1);
    }

    public void cleanUpAfterError(String comment) {
        this.cleanUpAfterError(comment, null);
    }

    public void cleanUpAfterError(Exception error) {
        this.cleanUpAfterError(null, error);
    }

    public void cleanUpAfterError() {
        this.cleanUpAfterError(null, null);
    }

    public void cleanUp() {
        while (this.context != this.root) {
            this.contextClose(this.context);
        }
        if (this.verbosity >= 100) {
            this.propagateBounds(this.context);
            try {
                this.insertTokens(this.context, 247, "comment", "text");
                this.insertTokens(this.context, 21, "directive", "text");
            }
            catch (IOException error) {
                error.printStackTrace();
                System.exit(1);
            }
            this.propagateBounds(this.context);
        }
        try {
            this.persist();
        }
        catch (Exception error) {
            error.printStackTrace();
            System.exit(1);
        }
    }

    private class TokenTarget {
        public Element element;
        public int index;

        public TokenTarget(Element target, int targetIndex) {
            this.element = target;
            this.index = targetIndex;
        }
    }
}

