/*
 * Decompiled with CFR 0.152.
 */
package fortran.ofp;

import fortran.ofp.XMLPrinterBase;
import fortran.ofp.parser.java.IFortranParser;
import java.util.ArrayList;
import java.util.Arrays;
import org.antlr.runtime.Token;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XMLPrinter
extends XMLPrinterBase {
    public XMLPrinter(String[] args, IFortranParser parser, String filename) {
        super(args, parser, filename);
    }

    protected void genericOperationForceOpen(int nodesCount) {
        ArrayList<Element> nodes = this.contextNodes(-nodesCount, nodesCount);
        this.contextOpen("operation");
        if (nodesCount == 2) {
            this.setAttribute("type", "unary");
        } else if (nodesCount > 2) {
            this.setAttribute("type", "multiary");
        } else {
            this.cleanUpAfterError("didn't expect nodesCount=" + nodesCount);
        }
        for (Element node : nodes) {
            boolean needsTransform;
            boolean bl = needsTransform = !node.getTagName().equals("operand") && !node.getTagName().equals("operator");
            if (needsTransform) {
                this.contextOpen("operand");
            }
            this.moveHere(node);
            if (!needsTransform) continue;
            this.contextClose();
        }
    }

    protected void genericOperationOpen(int numberOfOperators) {
        if (numberOfOperators > 0) {
            int nodesCount = 2 * numberOfOperators + 1;
            this.genericOperationForceOpen(nodesCount);
        }
    }

    protected void genericOperationClose(int numberOfOperators) {
        if (numberOfOperators > 0) {
            this.contextClose();
        }
    }

    protected void genericLoopControl(boolean hasStep) {
        String[] contexts = new String[]{"lower-bound", "upper-bound", "step"};
        int takenNodesCount = hasStep ? 3 : 2;
        ArrayList<Element> takenNodes = this.contextNodes(-takenNodesCount, takenNodesCount);
        this.context = this.contextNode(-takenNodesCount - 1);
        for (int i = 0; i < takenNodes.size(); ++i) {
            this.contextOpen(contexts[i]);
            this.moveHere(takenNodes.get(i));
            this.contextClose();
        }
        this.contextClose();
    }

    public void generic_name_list_part(Token id) {
        this.contextOpen("name");
        this.setAttribute("id", id);
        if (this.verbosity >= 100) {
            super.generic_name_list_part(id);
        }
        this.contextClose();
    }

    public void generic_name_list__begin() {
        if (this.context.getTagName().equals("specification") || this.context.getTagName().equals("file")) {
            this.contextOpen("declaration");
        }
        this.contextOpen("names");
        if (this.verbosity >= 100) {
            super.generic_name_list__begin();
        }
    }

    public void generic_name_list(int count) {
        if (this.verbosity >= 100) {
            super.generic_name_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("names");
    }

    public void specification_part(int numUseStmts, int numImportStmts, int numImplStmts, int numDeclConstructs) {
        if (this.context.getTagName().equals("header")) {
            this.contextClose("header");
            this.contextOpen("body");
        }
        if (this.context.getTagName().equals("declaration")) {
            this.contextClose("declaration");
        }
        if (!this.context.getTagName().equals("specification")) {
            this.contextOpen("specification");
        }
        this.contextCloseAllInner("specification");
        if (this.verbosity >= 80) {
            super.specification_part(numUseStmts, numImportStmts, numImplStmts, numDeclConstructs);
        }
        this.setAttribute("uses", numUseStmts);
        this.setAttribute("imports", numImportStmts);
        this.setAttribute("implicits", numImplStmts);
        this.setAttribute("declarations", numDeclConstructs);
        this.contextClose();
        this.contextOpen("statement");
    }

    public void declaration_construct() {
        this.contextClose("declaration");
        if (this.verbosity >= 100) {
            super.declaration_construct();
        }
        this.contextOpen("declaration");
    }

    public void execution_part_construct() {
        if (this.verbosity >= 100) {
            super.execution_part_construct();
        }
    }

    public void specification_stmt() {
        if (this.verbosity >= 100) {
            super.specification_stmt();
        }
    }

    public void executable_construct() {
        if (this.verbosity >= 100) {
            super.executable_construct();
        }
    }

    public void action_stmt() {
        if (this.contextTryFind("statement") == null) {
            this.contextClose();
            Element element = this.contextNode(-1);
            this.contextOpen("statement");
            this.moveHere(element);
        }
        if (this.verbosity >= 100) {
            super.action_stmt();
        }
        this.contextClose("statement");
        this.contextOpen("statement");
    }

    public void keyword() {
        if (this.verbosity >= 100) {
            super.keyword();
        }
    }

    public void name(Token id) {
        super.name(id);
    }

    public void constant(Token id) {
        super.constant(id);
    }

    public void scalar_constant() {
        if (this.verbosity >= 100) {
            super.scalar_constant();
        }
    }

    public void literal_constant() {
        if (this.verbosity >= 100) {
            super.literal_constant();
        }
        this.contextClose("literal");
    }

    public void label(Token lbl) {
        boolean closedLoop = false;
        for (Element outerContext = this.context; outerContext != this.root; outerContext = (Element)outerContext.getParentNode()) {
            if (!outerContext.getTagName().equals("loop") || !outerContext.getAttribute("label").equals(lbl.getText())) continue;
            this.context = outerContext;
            closedLoop = true;
            break;
        }
        super.label(lbl);
        if (closedLoop) {
            this.contextOpen("statement");
        }
    }

    public void intrinsic_type_spec(Token keyword1, Token keyword2, int type, boolean hasKindSelector) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "variable");
        super.intrinsic_type_spec(keyword1, keyword2, type, hasKindSelector);
    }

    public void kind_selector(Token token1, Token token2, boolean hasExpression) {
        if (hasExpression) {
            Element value = this.contextNode(-1);
            this.contextOpen("kind");
            this.moveHere(value);
        } else {
            this.contextOpen("kind");
            this.setAttribute("value", token2);
        }
        super.kind_selector(token1, token2, hasExpression);
        this.contextClose();
    }

    public void int_literal_constant(Token digitString, Token kindParam) {
        this.contextOpen("literal");
        this.setAttribute("type", "int");
        this.setAttribute("value", digitString);
        super.int_literal_constant(digitString, kindParam);
    }

    public void boz_literal_constant(Token constant) {
        this.contextOpen("literal");
        this.setAttribute("type", "int");
        this.setAttribute("value", constant);
        super.boz_literal_constant(constant);
    }

    public void real_literal_constant(Token realConstant, Token kindParam) {
        this.contextOpen("literal");
        this.setAttribute("type", "real");
        this.setAttribute("value", realConstant);
        super.real_literal_constant(realConstant, kindParam);
    }

    public void char_length(boolean hasTypeParamValue) {
        Element value = this.contextNode(-1);
        this.contextOpen("length");
        this.moveHere(value);
        super.char_length(hasTypeParamValue);
        this.contextClose();
    }

    public void scalar_int_literal_constant() {
        if (this.verbosity >= 100) {
            super.scalar_int_literal_constant();
        }
        this.contextClose("literal");
    }

    public void char_literal_constant(Token digitString, Token id, Token str) {
        this.contextOpen("literal");
        this.setAttribute("type", "char");
        this.setAttribute("value", str);
        super.char_literal_constant(digitString, id, str);
    }

    public void logical_literal_constant(Token logicalValue, boolean isTrue, Token kindParam) {
        this.contextOpen("literal");
        this.setAttribute("type", "bool");
        this.setAttribute("value", isTrue);
        super.logical_literal_constant(logicalValue, isTrue, kindParam);
    }

    public void derived_type_stmt(Token label, Token keyword, Token id, Token eos, boolean hasTypeAttrSpecList, boolean hasGenericNameList) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "type");
        super.derived_type_stmt(label, keyword, id, eos, hasTypeAttrSpecList, hasGenericNameList);
    }

    public void derived_type_spec(Token typeName, boolean hasTypeParamSpecList) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "variable");
        super.derived_type_spec(typeName, hasTypeParamSpecList);
    }

    public void array_constructor() {
        this.context = this.contextNode(-1);
        if (this.verbosity >= 100) {
            super.array_constructor();
        }
        this.contextClose();
    }

    public void ac_spec() {
        this.context = this.contextNode(-1);
        if (this.verbosity >= 100) {
            super.ac_spec();
        }
        this.contextClose();
    }

    public void ac_value() {
        this.contextClose("value");
        if (this.verbosity >= 100) {
            super.ac_value();
        }
        this.contextOpen("value");
    }

    public void ac_value_list__begin() {
        this.contextOpen("array-constructor-values");
        if (this.verbosity >= 100) {
            super.ac_value_list__begin();
        }
        this.contextOpen("value");
    }

    public void ac_value_list(int count) {
        this.contextClose("value");
        this.contextCloseAllInner("array-constructor-values", "array-constructor");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.ac_value_list(count);
        }
        this.contextClose();
    }

    public void ac_implied_do() {
        super.ac_implied_do();
        this.contextRename("array-constructor-values", "array-constructor");
        this.contextOpen("value");
    }

    public void ac_implied_do_control(boolean hasStride) {
        this.genericLoopControl(hasStride);
        Element element = this.contextNode(-1);
        this.contextClose("value");
        this.contextOpen("header");
        this.moveHere(element);
        super.ac_implied_do_control(hasStride);
        this.contextClose();
    }

    public void type_declaration_stmt(Token label, int numAttributes, Token eos) {
        super.type_declaration_stmt(label, numAttributes, eos);
    }

    public void declaration_type_spec(Token udtKeyword, int type) {
        ArrayList<Element> typeDeclarations = this.contextNodes();
        this.contextOpen("type");
        this.setAttribute("hasLength", false);
        this.setAttribute("hasKind", false);
        for (Element declaration : typeDeclarations) {
            switch (declaration.getTagName()) {
                case "intrinsic-type-spec": {
                    Attr n = this.getAttribute("name");
                    if (n != null) {
                        new IllegalArgumentException(declaration.getTagName());
                    }
                    this.setAttribute("name", declaration.getAttribute("keyword1"));
                    this.setAttribute("type", "intrinsic");
                    break;
                }
                case "derived-type-spec": {
                    Attr n = this.getAttribute("name");
                    if (n != null) {
                        new IllegalArgumentException(declaration.getTagName());
                    }
                    this.setAttribute("name", declaration.getAttribute("typeName"));
                    this.setAttribute("type", "derived");
                    break;
                }
                case "length": {
                    this.setAttribute("hasLength", true);
                    break;
                }
                case "kind": {
                    this.setAttribute("hasKind", true);
                    break;
                }
            }
            this.moveHere(declaration);
        }
        super.declaration_type_spec(udtKeyword, type);
        this.contextClose();
    }

    public void attr_spec(Token attrKeyword, int attr) {
        String nestIn = "";
        switch (attr) {
            case 801: {
                break;
            }
            case 802: {
                break;
            }
            case 805: {
                nestIn = "allocatable";
                break;
            }
            case 806: {
                nestIn = "asynchronous";
                break;
            }
            case 807: {
                nestIn = "codimension";
                break;
            }
            case 809: {
                break;
            }
            case 810: {
                nestIn = "external";
                break;
            }
            case 811: {
                break;
            }
            case 812: {
                nestIn = "intrinsic";
                break;
            }
            case 814: {
                nestIn = "optional";
                break;
            }
            case 815: {
                nestIn = "parameter";
                break;
            }
            case 816: {
                nestIn = "pointer";
                break;
            }
            case 817: {
                nestIn = "protected";
                break;
            }
            case 818: {
                nestIn = "save";
                break;
            }
            case 819: {
                nestIn = "target";
                break;
            }
            case 820: {
                nestIn = "value";
                break;
            }
            case 821: {
                nestIn = "volatile";
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(attr) + " - " + attrKeyword);
            }
        }
        if (nestIn.length() > 0) {
            this.contextOpen("attribute-" + nestIn);
        }
        super.attr_spec(attrKeyword, attr);
        if (nestIn.length() > 0) {
            this.contextClose();
        }
    }

    public void entity_decl(Token id, boolean hasArraySpec, boolean hasCoarraySpec, boolean hasCharLength, boolean hasInitialization) {
        this.contextCloseAllInner("variable");
        super.entity_decl(id, hasArraySpec, hasCoarraySpec, hasCharLength, hasInitialization);
        this.setAttribute("name", id);
        this.setAttribute("hasInitialValue", hasInitialization);
        this.contextClose();
        this.contextOpen("variable");
    }

    public void entity_decl_list__begin() {
        this.contextOpen("variables");
        if (this.verbosity >= 100) {
            super.entity_decl_list__begin();
        }
        this.contextOpen("variable");
    }

    public void entity_decl_list(int count) {
        this.contextClose("variable");
        this.contextCloseAllInner("variables");
        if (this.verbosity >= 100) {
            super.entity_decl_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void initialization(boolean hasExpr, boolean hasNullInit) {
        Element initialValue = this.contextNode(-1);
        this.contextOpen("initial-value");
        this.moveHere(initialValue);
        super.initialization(hasExpr, hasNullInit);
        this.contextClose();
    }

    public void access_spec(Token keyword, int type) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        super.access_spec(keyword, type);
    }

    public void language_binding_spec(Token keyword, Token id, boolean hasName) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        super.language_binding_spec(keyword, id, hasName);
    }

    public void array_spec(int count) {
        this.contextCloseAllInner("dimensions");
        if (this.verbosity >= 100) {
            super.array_spec(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void array_spec_element(int type) {
        Element value = null;
        Element value2 = null;
        switch (type) {
            case 702: {
                value2 = this.contextNode(-2);
            }
            case 700: 
            case 701: 
            case 703: {
                value = this.contextNode(-1);
                break;
            }
            case 704: 
            case 705: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        if (!this.context.getTagName().equals("dimensions")) {
            this.contextOpen("dimensions");
        }
        this.contextOpen("dimension");
        switch (type) {
            case 700: {
                this.setAttribute("type", "simple");
                this.moveHere(value);
                break;
            }
            case 701: {
                this.setAttribute("type", "upper-bound-assumed-shape");
                this.moveHere(value);
                break;
            }
            case 702: {
                this.setAttribute("type", "range");
                this.contextOpen("range");
                this.contextOpen("lower-bound");
                this.moveHere(value2);
                this.contextClose();
                this.contextOpen("upper-bound");
                this.moveHere(value);
                this.contextClose();
                this.contextClose();
                break;
            }
            case 703: {
                this.setAttribute("type", "upper-bound-assumed-size");
                this.moveHere(value);
                break;
            }
            case 704: {
                this.setAttribute("type", "assumed-size");
                break;
            }
            case 705: {
                this.setAttribute("type", "assumed-shape");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        super.array_spec_element(type);
        this.contextClose();
    }

    public void intent_spec(Token intentKeyword1, Token intentKeyword2, int intent) {
        this.contextOpen("intent");
        switch (intent) {
            case 600: {
                this.setAttribute("type", "in");
                break;
            }
            case 601: {
                this.setAttribute("type", "out");
                break;
            }
            case 602: {
                this.setAttribute("type", "inout");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(intent));
            }
        }
        if (this.verbosity >= 100) {
            super.intent_spec(intentKeyword1, intentKeyword2, intent);
        }
        this.contextClose();
    }

    public void access_id_list__begin() {
        if (this.verbosity >= 100) {
            super.access_id_list__begin();
        }
    }

    public void access_id_list(int count) {
        super.access_id_list(count);
    }

    public void allocatable_decl_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "allocatables");
        super.allocatable_decl_list__begin();
    }

    public void asynchronous_stmt(Token label, Token keyword, Token eos) {
        if (!this.context.getTagName().equals("declaration")) {
            Element value = this.contextNode(-1);
            if (value.getTagName() != "names") {
                this.cleanUpAfterError("tag name is not 'names' but '" + value.getTagName() + "'");
            }
            this.contextOpen("declaration");
            this.moveHere(value);
        }
        super.asynchronous_stmt(label, keyword, eos);
    }

    public void codimension_decl_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "codimensions");
        super.codimension_decl_list__begin();
    }

    public void data_stmt_object() {
        if (this.verbosity >= 100) {
            super.data_stmt_object();
        }
    }

    public void data_stmt_object_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "data");
        this.contextOpen("variables");
        if (this.verbosity >= 100) {
            super.data_stmt_object_list__begin();
        }
    }

    public void data_stmt_object_list(int count) {
        this.contextCloseAllInner("variables");
        if (this.verbosity >= 100) {
            super.data_stmt_object_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("variables");
    }

    public void data_stmt_value(Token asterisk) {
        if (this.verbosity >= 100) {
            super.data_stmt_value(asterisk);
        }
    }

    public void data_stmt_value_list__begin() {
        this.contextOpen("values");
        if (this.verbosity >= 100) {
            super.data_stmt_value_list__begin();
        }
    }

    public void data_stmt_value_list(int count) {
        this.contextCloseAllInner("values");
        if (this.verbosity >= 100) {
            super.data_stmt_value_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("values");
    }

    public void hollerith_literal_constant(Token hollerithConstant) {
        this.contextOpen("literal");
        this.setAttribute("type", "hollerith");
        this.setAttribute("value", hollerithConstant);
        super.hollerith_literal_constant(hollerithConstant);
    }

    public void dimension_stmt(Token label, Token keyword, Token eos, int count) {
        this.contextCloseAllInner("variables");
        this.setAttribute("count", count);
        super.dimension_stmt(label, keyword, eos, count);
        this.contextClose();
        this.setAttribute("type", "variable-dimensions");
    }

    public void dimension_decl(Token id) {
        Element value = this.contextNode(-1);
        if (!this.context.getTagName().equals("variables")) {
            if (!this.context.getTagName().equals("declaration")) {
                this.contextOpen("declaration");
            }
            this.contextOpen("variables");
        }
        this.contextOpen("variable");
        this.setAttribute("name", id);
        this.moveHere(value);
        super.dimension_decl(id);
        this.contextClose("variable");
    }

    public void named_constant_def_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "parameter");
        this.contextOpen("constants");
        if (this.verbosity >= 100) {
            super.named_constant_def_list__begin();
        }
    }

    public void named_constant_def_list(int count) {
        this.contextCloseAllInner("constants");
        if (this.verbosity >= 100) {
            super.named_constant_def_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("constants");
    }

    public void named_constant_def(Token id) {
        Element value = this.contextNode(-1);
        this.contextOpen("constant");
        this.setAttribute("name", id);
        this.moveHere(value);
        if (this.verbosity >= 100) {
            super.named_constant_def(id);
        }
        this.contextClose();
    }

    public void pointer_decl_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        super.pointer_decl_list__begin();
    }

    public void save_stmt(Token label, Token keyword, Token eos, boolean hasSavedEntityList) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        super.save_stmt(label, keyword, eos, hasSavedEntityList);
    }

    public void target_decl_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "targets");
        if (this.verbosity >= 100) {
            super.target_decl_list__begin();
        }
    }

    public void target_decl_list(int count) {
        super.target_decl_list(count);
    }

    public void value_stmt(Token label, Token keyword, Token eos) {
        Element value = this.contextNode(-1);
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "value");
        this.moveHere(value);
        super.value_stmt(label, keyword, eos);
    }

    public void volatile_stmt(Token label, Token keyword, Token eos) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "volatile");
        super.volatile_stmt(label, keyword, eos);
    }

    public void implicit_stmt(Token label, Token implicitKeyword, Token noneKeyword, Token eos, boolean hasImplicitSpecList) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        if (this.verbosity >= 20) {
            super.implicit_stmt(label, implicitKeyword, noneKeyword, eos, hasImplicitSpecList);
        }
        this.setAttribute("type", "implicit");
        this.setAttribute("subtype", noneKeyword == null ? "some" : "none");
        this.contextClose("declaration");
        this.contextOpen("declaration");
    }

    public void letter_spec(Token id1, Token id2) {
        this.contextOpen("letter-range");
        this.setAttribute("begin", id1);
        this.setAttribute("end", id2);
        if (this.verbosity >= 100) {
            super.letter_spec(id1, id2);
        }
        this.contextClose();
    }

    public void letter_spec_list__begin() {
        this.contextOpen("letter-ranges");
        if (this.verbosity >= 100) {
            super.letter_spec_list__begin();
        }
    }

    public void letter_spec_list(int count) {
        this.contextCloseAllInner("letter-ranges");
        if (this.verbosity >= 100) {
            super.letter_spec_list(count);
        }
        this.contextClose();
    }

    public void namelist_stmt(Token label, Token keyword, Token eos, int count) {
        this.contextCloseAllInner("namelists");
        super.namelist_stmt(label, keyword, eos, count);
        this.setAttribute("count", count);
    }

    public void namelist_group_name(Token id) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "namelists");
        this.contextOpen("namelists");
        this.contextOpen("names");
        if (this.verbosity >= 100) {
            super.namelist_group_name(id);
        }
        this.setAttribute("id", id);
    }

    public void namelist_group_object_list(int count) {
        this.contextCloseAllInner("names");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.namelist_group_object_list(count);
        }
        this.contextClose();
    }

    public void equivalence_set_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "equivalence");
        this.contextOpen("equivalents");
        if (this.verbosity >= 100) {
            super.equivalence_set_list__begin();
        }
        this.contextOpen("equivalent");
    }

    public void equivalence_set_list(int count) {
        this.contextClose("equivalent");
        this.contextCloseAllInner("equivalents");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.equivalence_set_list(count);
        }
        this.contextClose();
    }

    public void equivalence_object() {
        this.contextClose("equivalent");
        if (this.verbosity >= 100) {
            super.equivalence_object();
        }
        this.contextOpen("equivalent");
    }

    public void equivalence_object_list__begin() {
        super.equivalence_object_list__begin();
    }

    public void equivalence_object_list(int count) {
        super.equivalence_object_list(count);
    }

    public void common_block_name(Token id) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "common");
        super.common_block_name(id);
    }

    public void common_block_object_list__begin() {
        this.contextOpen("objects");
        if (this.verbosity >= 100) {
            super.common_block_object_list__begin();
        }
    }

    public void common_block_object_list(int count) {
        this.contextCloseAllInner("objects");
        if (this.verbosity >= 100) {
            super.common_block_object_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void variable() {
        if (this.verbosity >= 100) {
            super.variable();
        }
        this.setAttribute("type", "variable");
        this.contextClose("name");
    }

    public void designator_or_func_ref() {
        if (this.verbosity >= 100) {
            super.designator_or_func_ref();
        }
        this.setAttribute("type", "ambiguous");
        this.contextClose("name");
    }

    public void substring_range(boolean hasLowerBound, boolean hasUpperBound) {
        Element lowerBound = null;
        Element upperBound = null;
        if (hasLowerBound) {
            lowerBound = this.contextNode(-1);
        }
        if (hasUpperBound) {
            upperBound = lowerBound;
            lowerBound = hasLowerBound ? this.contextNode(-2) : null;
        }
        this.contextOpen("name");
        this.contextOpen("range");
        if (lowerBound != null) {
            this.contextOpen("lower-bound");
            this.moveHere(lowerBound);
            this.contextClose();
        }
        if (upperBound != null) {
            this.contextOpen("upper-bound");
            this.moveHere(upperBound);
            this.contextClose();
        }
        if (this.verbosity >= 100) {
            super.substring_range(hasLowerBound, hasUpperBound);
        }
        this.contextClose();
    }

    public void data_ref(int numPartRef) {
        if (numPartRef > 1) {
            assert (numPartRef == 2);
            assert (this.context.getTagName().equals("name"));
            Element innerName = this.context;
            ArrayList<Element> elements = this.contextNodes();
            Attr innerNameId = this.getAttribute("id");
            this.contextClose();
            assert (this.context.getTagName().equals("name"));
            this.moveHere(elements);
            this.setAttribute("id", this.getAttribute("id") + "%" + innerNameId.getValue());
            this.context.removeChild(innerName);
        }
        super.data_ref(numPartRef);
    }

    public void part_ref(Token id, boolean hasSectionSubscriptList, boolean hasImageSelector) {
        Element e = null;
        if (hasSectionSubscriptList && !(e = this.contextNode(-1)).getTagName().equals("subscripts")) {
            this.cleanUpAfterError("tag name is not 'subscripts' but '" + e.getTagName() + "'");
        }
        this.contextOpen("name");
        this.setAttribute("id", id);
        this.setAttribute("hasSubscripts", hasSectionSubscriptList);
        if (hasSectionSubscriptList) {
            this.moveHere(e);
        }
        if (this.verbosity >= 60) {
            super.part_ref(id, hasSectionSubscriptList, hasImageSelector);
        }
    }

    public void section_subscript(boolean hasLowerBound, boolean hasUpperBound, boolean hasStride, boolean isAmbiguous) {
        Element outerContext = this.context;
        this.contextOpen("subscript");
        if (!(hasLowerBound || hasUpperBound || hasStride)) {
            this.setAttribute("type", "empty");
        } else if (hasLowerBound && !hasUpperBound && !hasStride) {
            this.setAttribute("type", "simple");
            this.moveHere(this.contextNode(outerContext, -2));
        } else {
            this.setAttribute("type", "range");
            Element lowerBound = null;
            Element upperBound = null;
            Element step = null;
            this.contextOpen("range");
            if (hasLowerBound) {
                lowerBound = this.contextOpen("lower-bound");
                this.contextClose();
            }
            if (hasUpperBound) {
                upperBound = this.contextOpen("upper-bound");
                this.contextClose();
            }
            if (hasStride) {
                step = this.contextOpen("step");
                this.contextClose();
            }
            this.contextClose();
            if (hasStride) {
                this.moveTo(step, this.contextNode(outerContext, -2));
            }
            if (hasUpperBound) {
                this.moveTo(upperBound, this.contextNode(outerContext, -2));
            }
            if (hasLowerBound) {
                this.moveTo(lowerBound, this.contextNode(outerContext, -2));
            }
        }
        if (this.verbosity >= 80) {
            super.section_subscript(hasLowerBound, hasUpperBound, hasStride, isAmbiguous);
        }
        this.contextClose();
    }

    public void section_subscript_list__begin() {
        this.contextOpen("subscripts");
        if (this.verbosity >= 100) {
            super.section_subscript_list__begin();
        }
    }

    public void section_subscript_list(int count) {
        this.contextCloseAllInner("subscripts");
        if (this.verbosity >= 100) {
            super.section_subscript_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("subscripts");
    }

    public void allocate_stmt(Token label, Token allocateKeyword, Token eos, boolean hasTypeSpec, boolean hasAllocOptList) {
        int movedCount = 1 + (hasAllocOptList ? 1 : 0);
        ArrayList<Element> elements = this.contextNodes(-movedCount, movedCount);
        this.contextOpen("allocate");
        this.moveHere(elements);
        super.allocate_stmt(label, allocateKeyword, eos, hasTypeSpec, hasAllocOptList);
        this.contextClose();
    }

    public void alloc_opt(Token allocOpt) {
        this.contextCloseAllInner("keyword-arguments");
        Element element = this.contextNode(-1);
        this.contextOpen("keyword-argument");
        this.setAttribute("name", allocOpt);
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.alloc_opt(allocOpt);
        }
        this.contextClose();
    }

    public void alloc_opt_list__begin() {
        this.contextOpen("keyword-arguments");
        if (this.verbosity >= 100) {
            super.alloc_opt_list__begin();
        }
    }

    public void alloc_opt_list(int count) {
        this.contextCloseAllInner("keyword-arguments");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.alloc_opt_list(count);
        }
        this.contextClose();
    }

    public void allocation(boolean hasAllocateShapeSpecList, boolean hasAllocateCoarraySpec) {
        Element element;
        if (hasAllocateShapeSpecList || hasAllocateCoarraySpec) {
            this.cleanUpAfterError("didn't expect hasAllocateShapeSpecList=" + hasAllocateShapeSpecList + " hasAllocateCoarraySpec=" + hasAllocateCoarraySpec);
        }
        if ((element = this.contextNode(-1)).getTagName().equals("expression")) {
            this.context = element;
        } else {
            this.contextOpen("expression");
            this.moveHere(element);
        }
        super.allocation(hasAllocateShapeSpecList, hasAllocateCoarraySpec);
        this.contextClose();
    }

    public void allocation_list__begin() {
        this.contextOpen("expressions");
        if (this.verbosity >= 100) {
            super.allocation_list__begin();
        }
    }

    public void allocation_list(int count) {
        this.contextCloseAllInner("expressions");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.allocation_list(count);
        }
        this.contextClose();
    }

    public void allocate_object() {
        this.setAttribute("type", "variable");
        this.contextClose("name");
        Element element = this.contextNode(-1);
        this.contextOpen("expression");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.allocate_object();
        }
        this.contextClose();
    }

    public void allocate_object_list__begin() {
        this.contextOpen("expressions");
        if (this.verbosity >= 100) {
            super.allocate_object_list__begin();
        }
    }

    public void allocate_object_list(int count) {
        this.contextCloseAllInner("expressions");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.allocate_object_list(count);
        }
        this.contextClose();
    }

    public void deallocate_stmt(Token label, Token deallocateKeyword, Token eos, boolean hasDeallocOptList) {
        Element element2 = hasDeallocOptList ? this.contextNode(-2) : null;
        Element element = this.contextNode(-1);
        this.contextOpen("deallocate");
        if (hasDeallocOptList) {
            this.moveHere(element2);
        }
        this.moveHere(element);
        super.deallocate_stmt(label, deallocateKeyword, eos, hasDeallocOptList);
        this.contextClose();
    }

    public void dealloc_opt(Token id) {
        this.contextCloseAllInner("keyword-arguments");
        Element element = this.contextNode(-1);
        this.contextOpen("keyword-argument");
        this.setAttribute("name", id);
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.dealloc_opt(id);
        }
        this.contextClose();
    }

    public void dealloc_opt_list__begin() {
        this.contextOpen("keyword-arguments");
        if (this.verbosity >= 100) {
            super.dealloc_opt_list__begin();
        }
    }

    public void dealloc_opt_list(int count) {
        this.contextCloseAllInner("keyword-arguments");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.dealloc_opt_list(count);
        }
        this.contextClose();
    }

    public void primary() {
        this.context = this.contextNode(-1);
        if (this.verbosity >= 100) {
            super.primary();
        }
        this.contextClose();
    }

    public void parenthesized_expr() {
        this.context = this.contextNode(-1);
        if (this.verbosity >= 100) {
            super.parenthesized_expr();
        }
        this.contextClose();
    }

    public void power_operand(boolean hasPowerOperand) {
        int numPowerOp = hasPowerOperand ? 1 : 0;
        this.genericOperationOpen(numPowerOp);
        if (this.verbosity >= 100) {
            super.power_operand(hasPowerOperand);
        }
        this.genericOperationClose(numPowerOp);
    }

    public void power_operand__power_op(Token powerOp) {
        if (this.verbosity >= 100) {
            super.power_operand__power_op(powerOp);
        }
        this.cleanUpAfterError();
    }

    public void mult_operand(int numMultOps) {
        this.genericOperationOpen(numMultOps);
        if (this.verbosity >= 100) {
            super.mult_operand(numMultOps);
        }
        this.genericOperationClose(numMultOps);
    }

    public void mult_operand__mult_op(Token multOp) {
        Element element = this.contextNode(-1);
        this.contextOpen("operand");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.mult_operand__mult_op(multOp);
        }
        this.contextClose();
    }

    public void signed_operand(Token addOp) {
        if (addOp != null) {
            this.genericOperationForceOpen(2);
        }
        if (this.verbosity >= 100) {
            super.signed_operand(addOp);
        }
        if (addOp != null) {
            this.genericOperationClose(1);
        }
    }

    public void add_operand(int numAddOps) {
        this.genericOperationOpen(numAddOps);
        if (this.verbosity >= 100) {
            super.add_operand(numAddOps);
        }
        this.genericOperationClose(numAddOps);
    }

    public void add_operand__add_op(Token addOp) {
        Element element = this.contextNode(-1);
        this.contextOpen("operand");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.add_operand__add_op(addOp);
        }
        this.contextClose();
    }

    public void level_2_expr(int numConcatOps) {
        this.genericOperationOpen(numConcatOps);
        if (this.verbosity >= 100) {
            super.level_2_expr(numConcatOps);
        }
        this.genericOperationClose(numConcatOps);
    }

    public void power_op(Token powerKeyword) {
        this.contextOpen("operator");
        this.setAttribute("operator", powerKeyword);
        if (this.verbosity >= 100) {
            super.power_op(powerKeyword);
        }
        this.contextClose();
    }

    public void mult_op(Token multKeyword) {
        this.contextOpen("operator");
        this.setAttribute("operator", multKeyword);
        if (this.verbosity >= 100) {
            super.mult_op(multKeyword);
        }
        this.contextClose();
    }

    public void add_op(Token addKeyword) {
        this.contextOpen("operator");
        this.setAttribute("operator", addKeyword);
        if (this.verbosity >= 100) {
            super.add_op(addKeyword);
        }
        this.contextClose();
    }

    public void level_3_expr(Token relOp) {
        int numRelOp = relOp == null ? 0 : 1;
        this.genericOperationOpen(numRelOp);
        if (this.verbosity >= 80) {
            super.level_3_expr(relOp);
        }
        this.genericOperationClose(numRelOp);
    }

    public void concat_op(Token concatKeyword) {
        this.contextOpen("operator");
        if (this.verbosity >= 100) {
            super.concat_op(concatKeyword);
        }
        this.setAttribute("operator", "//");
        this.contextClose();
    }

    public void rel_op(Token relOp) {
        this.contextOpen("operator");
        this.setAttribute("operator", relOp);
        if (this.verbosity >= 100) {
            super.rel_op(relOp);
        }
        this.contextClose();
    }

    public void and_operand(boolean hasNotOp, int numAndOps) {
        if (hasNotOp) {
            if (numAndOps == 0) {
                this.genericOperationForceOpen(2);
            } else {
                int nodesCount = 2 * numAndOps + 2;
                ArrayList<Element> nodes = this.contextNodes(-nodesCount, 2);
                Element reference = this.contextNode(-nodesCount + 2);
                Element operation = this.contextOpen("operation");
                this.setAttribute("type", "unary");
                for (Element node : nodes) {
                    boolean needsTransform;
                    boolean bl = needsTransform = !node.getTagName().equals("operand") && !node.getTagName().equals("operator");
                    if (needsTransform) {
                        this.contextOpen("operand");
                    }
                    this.moveHere(node);
                    if (!needsTransform) continue;
                    this.contextClose();
                }
                this.contextClose();
                this.context.removeChild(operation);
                this.context.insertBefore(operation, reference);
                this.genericOperationOpen(numAndOps);
            }
        } else {
            this.genericOperationOpen(numAndOps);
        }
        if (this.verbosity >= 100) {
            super.and_operand(hasNotOp, numAndOps);
        }
        if (hasNotOp) {
            this.genericOperationClose(numAndOps > 0 ? numAndOps : 1);
        } else {
            this.genericOperationClose(numAndOps);
        }
    }

    public void and_operand__not_op(boolean hasNotOp) {
        if (hasNotOp) {
            this.genericOperationForceOpen(2);
            this.genericOperationClose(1);
        }
        Element element = this.contextNode(-1);
        this.contextOpen("operand");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.and_operand__not_op(hasNotOp);
        }
        this.contextClose();
    }

    public void or_operand(int numOrOps) {
        this.genericOperationOpen(numOrOps);
        if (this.verbosity >= 100) {
            super.or_operand(numOrOps);
        }
        this.genericOperationClose(numOrOps);
    }

    public void not_op(Token notOp) {
        this.contextOpen("operator");
        this.setAttribute("operator", notOp);
        if (this.verbosity >= 100) {
            super.not_op(notOp);
        }
        this.contextClose();
    }

    public void and_op(Token andOp) {
        this.contextOpen("operator");
        this.setAttribute("operator", andOp);
        if (this.verbosity >= 100) {
            super.and_op(andOp);
        }
        this.contextClose();
    }

    public void or_op(Token orOp) {
        this.contextOpen("operator");
        this.setAttribute("operator", orOp);
        if (this.verbosity >= 100) {
            super.or_op(orOp);
        }
        this.contextClose();
    }

    public void equiv_op(Token equivOp) {
        super.equiv_op(equivOp);
    }

    public void assignment_stmt(Token label, Token eos) {
        ArrayList<Element> nodes = this.contextNodes();
        if (nodes.size() < 2) {
            this.cleanUpAfterError("there should be at least 2 nodes for 'assignment' but " + nodes.size() + " found");
        }
        Element target = this.contextNode(-2);
        Element value = this.contextNode(-1);
        this.contextOpen("assignment");
        this.contextOpen("target");
        this.moveHere(target);
        this.contextClose();
        this.contextOpen("value");
        this.moveHere(value);
        this.contextClose();
        if (this.verbosity >= 100) {
            super.assignment_stmt(label, eos);
        }
        this.contextClose();
    }

    public void pointer_assignment_stmt(Token label, Token eos, boolean hasBoundsSpecList, boolean hasBoundsRemappingList) {
        Element value = this.contextNode(-1);
        this.contextClose();
        Element target = this.contextNode(-1);
        this.contextOpen("pointer-assignment");
        this.contextOpen("target");
        this.moveHere(target);
        this.contextClose();
        this.contextOpen("value");
        this.moveHere(value);
        this.contextClose();
        super.pointer_assignment_stmt(label, eos, hasBoundsSpecList, hasBoundsRemappingList);
        this.contextClose();
    }

    public void forall_construct() {
        if (this.verbosity >= 100) {
            super.forall_construct();
        }
        this.contextClose("loop");
        this.contextOpen("statement");
    }

    public void forall_construct_stmt(Token label, Token id, Token forallKeyword, Token eos) {
        this.contextRename("statement", "loop");
        this.setAttribute("type", "forall");
        ArrayList<Element> elements = this.contextNodes();
        this.contextOpen("header");
        this.moveHere(elements);
        this.contextClose();
        super.forall_construct_stmt(label, id, forallKeyword, eos);
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void forall_header() {
        if (this.verbosity >= 100) {
            super.forall_header();
        }
    }

    public void forall_triplet_spec(Token id, boolean hasStride) {
        this.contextOpen("index-variable");
        this.setAttribute("name", id);
        this.contextClose();
        Element element = this.contextNode(-1);
        this.context.removeChild(element);
        this.context.insertBefore(element, this.contextNode(hasStride ? -3 : -2));
        this.genericLoopControl(hasStride);
        this.context = this.contextNode(-1);
        super.forall_triplet_spec(id, hasStride);
        this.contextClose();
    }

    public void forall_triplet_spec_list__begin() {
        this.contextOpen("index-variables");
        if (this.verbosity >= 100) {
            super.forall_triplet_spec_list__begin();
        }
    }

    public void forall_triplet_spec_list(int count) {
        this.contextCloseAllInner("index-variables");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.forall_triplet_spec_list(count);
        }
        this.contextClose();
    }

    public void forall_assignment_stmt(boolean isPointerAssignment) {
        Element assignment = this.contextNode(-1);
        if (!this.context.getTagName().equals("header")) {
            this.cleanUpAfterError("didn't expect <" + this.context.getTagName() + ">");
        }
        this.contextClose();
        this.contextOpen("body");
        this.contextOpen("statement");
        this.moveHere(assignment);
        this.context = assignment;
        if (!this.context.getTagName().equals("assignment")) {
            this.cleanUpAfterError("didn't expect <" + this.context.getTagName() + ">");
        }
        if (this.verbosity >= 100) {
            super.forall_assignment_stmt(isPointerAssignment);
        }
        this.contextClose();
        this.contextClose();
        this.contextClose();
    }

    public void end_forall_stmt(Token label, Token endKeyword, Token forallKeyword, Token id, Token eos) {
        this.contextCloseAllInner("loop");
        super.end_forall_stmt(label, endKeyword, forallKeyword, id, eos);
    }

    public void forall_stmt__begin() {
        this.contextRename("statement", "loop");
        this.setAttribute("type", "forall");
        if (this.verbosity >= 100) {
            super.forall_stmt__begin();
        }
        this.contextOpen("header");
    }

    public void forall_stmt(Token label, Token forallKeyword) {
        this.contextCloseAllInner("loop");
        super.forall_stmt(label, forallKeyword);
        this.contextClose();
        this.contextOpen("statement");
    }

    public void block() {
        this.contextCloseAllInner("body");
        if (this.verbosity >= 100) {
            super.block();
        }
    }

    public void if_construct() {
        this.contextCloseAllInner("if");
        if (this.verbosity >= 100) {
            super.if_construct();
        }
        this.contextClose();
        this.contextOpen("statement");
    }

    public void if_then_stmt(Token label, Token id, Token ifKeyword, Token thenKeyword, Token eos) {
        this.contextRename("statement", "if");
        ArrayList<Element> nodes = this.contextNodes();
        this.contextOpen("header");
        this.moveHere(nodes);
        this.contextClose();
        if (this.verbosity >= 80) {
            super.if_then_stmt(label, id, ifKeyword, thenKeyword, eos);
        }
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void else_if_stmt(Token label, Token elseKeyword, Token ifKeyword, Token thenKeyword, Token id, Token eos) {
        Element condition = this.contextNode(-1);
        this.contextClose("body");
        this.contextOpen("header");
        this.setAttribute("type", "else-if");
        this.moveHere(condition);
        this.contextClose();
        if (this.verbosity >= 80) {
            super.else_if_stmt(label, elseKeyword, ifKeyword, thenKeyword, id, eos);
        }
        this.contextOpen("body");
        this.setAttribute("type", "else-if");
        this.contextOpen("statement");
    }

    public void else_stmt(Token label, Token elseKeyword, Token id, Token eos) {
        this.contextClose("body");
        if (this.verbosity >= 80) {
            super.else_stmt(label, elseKeyword, id, eos);
        }
        this.contextOpen("body");
        this.setAttribute("type", "else");
        this.contextOpen("statement");
    }

    public void end_if_stmt(Token label, Token endKeyword, Token ifKeyword, Token id, Token eos) {
        this.contextCloseAllInner("if");
        if (this.verbosity >= 80) {
            super.end_if_stmt(label, endKeyword, ifKeyword, id, eos);
        }
    }

    public void if_stmt__begin() {
        this.contextRename("statement", "if");
        if (this.verbosity >= 100) {
            super.if_stmt__begin();
        }
        this.contextOpen("header");
        this.contextClose();
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void if_stmt(Token label, Token ifKeyword) {
        this.contextClose("body");
        Element ifHeader = this.contextNode(-2);
        Element ifBody = this.contextNode(-1);
        Element statementToBeFixed = this.contextNode(ifBody, 0);
        Element ifCondition = this.contextNode(statementToBeFixed, 0);
        if (!ifBody.getTagName().equals("body")) {
            this.cleanUpAfterError("if body node must be named body");
        }
        this.moveTo(ifHeader, ifCondition);
        this.contextCloseAllInner("if");
        super.if_stmt(label, ifKeyword);
        this.contextClose();
        this.contextOpen("statement");
    }

    public void block_construct() {
        if (this.verbosity >= 100) {
            super.block_construct();
        }
    }

    public void case_construct() {
        this.contextCloseAllInner("select");
        if (this.verbosity >= 100) {
            super.case_construct();
        }
        this.contextClose();
        this.contextOpen("statement");
    }

    public void select_case_stmt(Token label, Token id, Token selectKeyword, Token caseKeyword, Token eos) {
        this.contextRename("statement", "select");
        ArrayList<Element> nodes = this.contextNodes();
        this.contextOpen("header");
        this.moveHere(nodes);
        this.contextClose();
        super.select_case_stmt(label, id, selectKeyword, caseKeyword, eos);
        this.contextOpen("body");
    }

    public void case_stmt(Token label, Token caseKeyword, Token id, Token eos) {
        super.case_stmt(label, caseKeyword, id, eos);
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void end_select_stmt(Token label, Token endKeyword, Token selectKeyword, Token id, Token eos) {
        this.contextCloseAllInner("select");
        super.end_select_stmt(label, endKeyword, selectKeyword, id, eos);
    }

    public void case_selector(Token defaultToken) {
        if (!this.context.getTagName().equals("case") && this.contextTryFind("case") != null) {
            this.contextClose("case");
            this.contextOpen("case");
            this.setAttribute("type", "default");
            this.contextOpen("header");
            this.contextClose();
        }
        super.case_selector(defaultToken);
    }

    public void case_value_range() {
        this.contextClose("value-range");
        if (this.verbosity >= 100) {
            super.case_value_range();
        }
        this.contextOpen("value-range");
        this.contextOpen("value");
    }

    public void case_value_range_list__begin() {
        if (this.context.getTagName().equals("body") && ((Element)this.context.getParentNode()).getTagName().equals("case")) {
            this.contextClose("body");
            this.contextClose("case");
        }
        this.contextOpen("case");
        this.setAttribute("type", "specific");
        this.contextOpen("header");
        this.contextOpen("value-ranges");
        if (this.verbosity >= 100) {
            super.case_value_range_list__begin();
        }
        this.contextOpen("value-range");
        this.contextOpen("value");
    }

    public void case_value_range_list(int count) {
        this.contextCloseAllInner("value-ranges");
        if (this.verbosity >= 100) {
            super.case_value_range_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
        this.contextClose("header");
    }

    public void case_value_range_suffix() {
        this.contextCloseAllInner("value-range");
        if (this.verbosity >= 100) {
            super.case_value_range_suffix();
        }
    }

    public void case_value() {
        this.contextClose("value");
        if (this.verbosity >= 100) {
            super.case_value();
        }
        this.contextOpen("value");
    }

    public void associate_construct() {
        super.associate_construct();
        this.contextClose("associate");
        this.contextOpen("statement");
    }

    public void associate_stmt(Token label, Token id, Token associateKeyword, Token eos) {
        Element element = this.contextNode(-1);
        this.contextRename("statement", "associate");
        this.contextOpen("header");
        this.moveHere(element);
        this.contextClose();
        super.associate_stmt(label, id, associateKeyword, eos);
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void association_list__begin() {
        this.contextOpen("keyword-arguments");
        if (this.verbosity >= 100) {
            super.association_list__begin();
        }
    }

    public void association_list(int count) {
        this.contextCloseAllInner("keyword-arguments");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.association_list(count);
        }
        this.contextClose();
    }

    public void association(Token id) {
        this.context = this.contextNode(-1);
        assert (this.context.getNodeName().equals("keyword-argument"));
        this.setAttribute("argument-name", id);
        if (this.verbosity >= 100) {
            super.association(id);
        }
        this.contextClose();
    }

    public void selector() {
        Element element = this.contextNode(-1);
        this.contextOpen("keyword-argument");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.selector();
        }
        this.contextClose();
    }

    public void end_associate_stmt(Token label, Token endKeyword, Token associateKeyword, Token id, Token eos) {
        this.contextClose("body");
        super.end_associate_stmt(label, endKeyword, associateKeyword, id, eos);
    }

    public void type_guard_stmt(Token label, Token typeKeyword, Token isOrDefaultKeyword, Token selectConstructName, Token eos) {
        this.contextOpen("statement");
        super.type_guard_stmt(label, typeKeyword, isOrDefaultKeyword, selectConstructName, eos);
    }

    public void do_construct() {
        this.contextCloseAllInner("loop");
        if (this.verbosity >= 100) {
            super.do_construct();
        }
        this.contextClose();
        this.contextOpen("statement");
    }

    public void block_do_construct() {
        if (this.verbosity >= 100) {
            super.block_do_construct();
        }
    }

    public void do_stmt(Token label, Token id, Token doKeyword, Token digitString, Token eos, boolean hasLoopControl) {
        if (!hasLoopControl) {
            this.contextRename("statement", "loop");
            this.setAttribute("type", "do-label");
        }
        super.do_stmt(label, id, doKeyword, digitString, eos, hasLoopControl);
        this.contextOpen("body");
        this.contextOpen("statement");
    }

    public void label_do_stmt(Token label, Token id, Token doKeyword, Token digitString, Token eos, boolean hasLoopControl) {
        super.label_do_stmt(label, id, doKeyword, digitString, eos, hasLoopControl);
        this.cleanUpAfterError("didn't expect label-do-stmt");
    }

    public void loop_control(Token whileKeyword, int doConstructType, boolean hasOptExpr) {
        if (doConstructType == 1701) {
            this.genericLoopControl(hasOptExpr);
        }
        this.contextRename("statement", "loop");
        String loopType = "";
        switch (doConstructType) {
            case 1700: {
                loopType = "do-concurrent";
                break;
            }
            case 1701: {
                loopType = "do";
                break;
            }
            case 1702: {
                loopType = "do-while";
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(doConstructType));
            }
        }
        this.setAttribute("type", loopType);
        Element element = this.contextNode(-1);
        this.contextOpen("header");
        this.moveHere(element);
        super.loop_control(whileKeyword, doConstructType, hasOptExpr);
        this.contextClose();
    }

    public void do_variable(Token id) {
        this.contextOpen("index-variable");
        this.setAttribute("name", id);
        super.do_variable(id);
        this.contextClose();
    }

    public void end_do() {
        if (this.verbosity >= 100) {
            super.end_do();
        }
    }

    public void end_do_stmt(Token label, Token endKeyword, Token doKeyword, Token id, Token eos) {
        this.contextCloseAllInner("loop");
        if (this.verbosity >= 80) {
            super.end_do_stmt(label, endKeyword, doKeyword, id, eos);
        }
    }

    public void do_term_action_stmt(Token label, Token endKeyword, Token doKeyword, Token id, Token eos, boolean inserted) {
        this.contextCloseAllInner("loop");
        if (this.verbosity >= 80) {
            super.do_term_action_stmt(label, endKeyword, doKeyword, id, eos, inserted);
        }
    }

    public void cycle_stmt(Token label, Token cycleKeyword, Token id, Token eos) {
        this.contextOpen("cycle");
        if (this.verbosity >= 80) {
            super.cycle_stmt(label, cycleKeyword, id, eos);
        }
        this.contextClose();
    }

    public void exit_stmt(Token label, Token exitKeyword, Token id, Token eos) {
        this.contextOpen("exit");
        if (this.verbosity >= 80) {
            super.exit_stmt(label, exitKeyword, id, eos);
        }
        this.contextClose();
    }

    public void goto_stmt(Token label, Token goKeyword, Token toKeyword, Token target_label, Token eos) {
        super.goto_stmt(label, goKeyword, toKeyword, target_label, eos);
    }

    public void continue_stmt(Token label, Token continueKeyword, Token eos) {
        Element labelNode = this.contextNodesCount() > 0 ? this.contextNode(-1) : null;
        labelNode = labelNode != null && labelNode.getTagName() == "label" ? labelNode : null;
        this.contextOpen("statement");
        this.contextOpen("continue");
        if (labelNode != null) {
            this.moveHere(labelNode);
        }
        super.continue_stmt(label, continueKeyword, eos);
        this.contextClose();
    }

    public void stop_stmt(Token label, Token stopKeyword, Token eos, boolean hasStopCode) {
        if (hasStopCode) {
            Element value = this.contextNode(-1);
            this.contextOpen("stop");
            this.moveHere(value);
            Attr stopCode = this.getAttribute("digitString", value);
            this.setAttribute("code", stopCode.getValue());
        } else {
            this.contextOpen("stop");
            this.setAttribute("code", "");
        }
        if (this.verbosity >= 60) {
            super.stop_stmt(label, stopKeyword, eos, hasStopCode);
        }
        this.contextClose();
    }

    public void open_stmt(Token label, Token openKeyword, Token eos) {
        Element args = this.contextNode(-1);
        this.contextOpen("open");
        this.moveHere(args);
        super.open_stmt(label, openKeyword, eos);
        this.contextClose();
    }

    public void connect_spec(Token id) {
        this.contextCloseAllInner("keyword-argument");
        this.setAttribute("argument-name", id);
        this.contextClose();
        if (this.verbosity >= 100) {
            super.connect_spec(id);
        }
        this.contextOpen("keyword-argument");
    }

    public void connect_spec_list__begin() {
        this.contextOpen("keyword-arguments");
        if (this.verbosity >= 100) {
            super.connect_spec_list__begin();
        }
        this.contextOpen("keyword-argument");
    }

    public void connect_spec_list(int count) {
        this.contextClose("keyword-argument");
        this.contextCloseAllInner("keyword-arguments");
        if (this.verbosity >= 100) {
            super.connect_spec_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void close_stmt(Token label, Token closeKeyword, Token eos) {
        Element args = this.contextNode(-1);
        this.contextOpen("close");
        this.moveHere(args);
        super.close_stmt(label, closeKeyword, eos);
        this.contextClose();
    }

    public void close_spec(Token closeSpec) {
        this.contextCloseAllInner("keyword-argument");
        this.setAttribute("argument-name", closeSpec);
        this.contextClose();
        if (this.verbosity >= 100) {
            super.close_spec(closeSpec);
        }
        this.contextOpen("keyword-argument");
    }

    public void close_spec_list__begin() {
        this.contextOpen("keyword-arguments");
        if (this.verbosity >= 100) {
            super.close_spec_list__begin();
        }
        this.contextOpen("keyword-argument");
    }

    public void close_spec_list(int count) {
        this.contextClose("keyword-argument");
        this.contextCloseAllInner("keyword-arguments");
        if (this.verbosity >= 100) {
            super.close_spec_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void read_stmt(Token label, Token readKeyword, Token eos, boolean hasInputItemList) {
        Element outerContext = this.context;
        this.contextOpen("read");
        if (hasInputItemList) {
            this.moveHere(this.contextNode(outerContext, -3));
        }
        this.moveHere(this.contextNode(outerContext, -2));
        super.read_stmt(label, readKeyword, eos, hasInputItemList);
        this.contextClose();
    }

    public void write_stmt(Token label, Token writeKeyword, Token eos, boolean hasOutputItemList) {
        Element args = this.contextNode(-1);
        Element outputs = null;
        if (hasOutputItemList) {
            outputs = args;
            args = this.contextNode(-2);
        }
        this.contextOpen("write");
        this.moveHere(args);
        if (hasOutputItemList) {
            this.moveHere(outputs);
        }
        super.write_stmt(label, writeKeyword, eos, hasOutputItemList);
        this.contextClose();
    }

    public void print_stmt(Token label, Token printKeyword, Token eos, boolean hasOutputItemList) {
        Element outputs = hasOutputItemList ? this.contextNode(-1) : null;
        Element format = this.contextNode(hasOutputItemList ? -2 : -1);
        this.contextOpen("print");
        this.moveHere(format);
        if (hasOutputItemList) {
            this.moveHere(outputs);
        }
        super.print_stmt(label, printKeyword, eos, hasOutputItemList);
        this.contextClose();
    }

    public void io_control_spec(boolean hasExpression, Token keyword, boolean hasAsterisk) {
        if (hasExpression) {
            Element element = this.contextNode(-1);
            this.contextOpen("io-control");
            this.moveHere(element);
        } else {
            this.contextOpen("io-control");
        }
        this.setAttribute("argument-name", keyword == null ? "" : keyword);
        super.io_control_spec(hasExpression, keyword, hasAsterisk);
        this.contextClose("io-control");
    }

    public void io_control_spec_list__begin() {
        this.contextOpen("io-controls");
        if (this.verbosity >= 100) {
            super.io_control_spec_list__begin();
        }
    }

    public void io_control_spec_list(int count) {
        this.contextCloseAllInner("io-controls");
        if (this.verbosity >= 100) {
            super.io_control_spec_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void format() {
        Element node;
        Element label = null;
        if (this.contextNodesCount() > 0 && (node = this.contextNode(-1)).getNodeName().equals("literal")) {
            label = node;
        }
        this.contextOpen("print-format");
        this.setAttribute("type", label == null ? "*" : "label");
        if (label != null) {
            this.moveHere(label);
        }
        if (this.verbosity >= 100) {
            super.format();
        }
        this.contextClose();
    }

    public void input_item() {
        Element element = this.contextNode(-1);
        this.contextOpen("input");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.input_item();
        }
        this.contextClose("input");
    }

    public void input_item_list__begin() {
        this.contextOpen("inputs");
        if (this.verbosity >= 100) {
            super.input_item_list__begin();
        }
    }

    public void input_item_list(int count) {
        this.contextCloseAllInner("inputs");
        if (this.verbosity >= 100) {
            super.input_item_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void output_item() {
        Element element = this.contextNode(-1);
        this.contextOpen("output");
        this.moveHere(element);
        if (this.verbosity >= 100) {
            super.output_item();
        }
        this.contextClose();
    }

    public void output_item_list__begin() {
        this.contextOpen("outputs");
        if (this.verbosity >= 100) {
            super.output_item_list__begin();
        }
    }

    public void output_item_list(int count) {
        this.contextCloseAllInner("outputs");
        if (this.verbosity >= 100) {
            super.output_item_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose();
    }

    public void io_implied_do() {
        ArrayList<Element> elements = this.contextNodes();
        Element header = this.contextNode(-1);
        this.contextOpen("loop");
        this.setAttribute("type", "implied-do");
        this.contextOpen("body");
        for (Element node : elements) {
            if (!node.getTagName().equals("expression")) continue;
            this.moveHere(node);
        }
        this.contextClose();
        this.moveHere(header);
        super.io_implied_do();
        this.contextClose();
    }

    public void io_implied_do_object() {
        this.context = this.contextNode(-1);
        this.contextRename("expression");
        if (this.verbosity >= 100) {
            super.io_implied_do_object();
        }
        this.contextClose();
    }

    public void io_implied_do_control(boolean hasStride) {
        this.genericLoopControl(hasStride);
        Element element = this.contextNode(-1);
        this.contextOpen("header");
        this.moveHere(element);
        super.io_implied_do_control(hasStride);
        this.contextClose();
    }

    public void format_stmt(Token label, Token formatKeyword, Token eos) {
        Element labelNode = label != null ? this.contextNode(-2) : null;
        this.context = this.contextNode(-1);
        if (label != null) {
            this.moveHere(0, labelNode);
        }
        if (this.verbosity >= 60) {
            super.format_stmt(label, formatKeyword, eos);
        }
        this.contextClose();
    }

    public void format_specification(boolean hasFormatItemList) {
        Element items = hasFormatItemList ? this.contextNode(-1) : null;
        this.contextOpen("format");
        if (hasFormatItemList) {
            this.moveHere(items);
        }
        if (this.verbosity >= 60) {
            super.format_specification(hasFormatItemList);
        }
        this.contextClose();
    }

    public void format_item_list__begin() {
        this.contextOpen("format-items");
        if (this.verbosity >= 100) {
            super.format_item_list__begin();
        }
    }

    public void format_item_list(int count) {
        this.contextCloseAllInner("format-items");
        if (this.verbosity >= 100) {
            super.format_item_list(count);
        }
        this.setAttribute("count", count);
        this.contextClose("format-items");
    }

    public void main_program__begin() {
        this.contextOpen("program");
        if (this.verbosity >= 100) {
            super.main_program__begin();
        }
        this.contextOpen("header");
    }

    public void ext_function_subprogram(boolean hasPrefix) {
        this.context = this.contextNode(-1);
        if (this.verbosity >= 100) {
            super.ext_function_subprogram(hasPrefix);
        }
        this.contextClose();
    }

    public void main_program(boolean hasProgramStmt, boolean hasExecutionPart, boolean hasInternalSubprogramPart) {
        super.main_program(hasProgramStmt, hasExecutionPart, hasInternalSubprogramPart);
        this.contextClose("program");
    }

    public void program_stmt(Token label, Token programKeyword, Token id, Token eos) {
        this.contextClose("header");
        if (this.verbosity >= 20) {
            super.program_stmt(label, programKeyword, id, eos);
        }
        this.setAttribute("name", id);
        this.contextOpen("body");
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void end_program_stmt(Token label, Token endKeyword, Token programKeyword, Token id, Token eos) {
        if (this.contextTryFind("program") == null) {
            ArrayList<Element> nodes = this.contextNodes();
            this.contextOpen("program");
            this.moveHere(nodes);
        }
        this.contextCloseAllInner("program");
        super.end_program_stmt(label, endKeyword, programKeyword, id, eos);
    }

    public void module() {
        this.contextCloseAllInner("module");
        if (this.verbosity >= 100) {
            super.module();
        }
        this.contextClose();
    }

    public void module_stmt__begin() {
        this.contextOpen("module");
        if (this.verbosity >= 100) {
            super.module_stmt__begin();
        }
        this.contextOpen("header");
    }

    public void module_stmt(Token label, Token moduleKeyword, Token id, Token eos) {
        this.contextClose("header");
        this.setAttribute("name", id);
        super.module_stmt(label, moduleKeyword, id, eos);
        this.contextOpen("body");
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void end_module_stmt(Token label, Token endKeyword, Token moduleKeyword, Token id, Token eos) {
        if (!this.context.getTagName().equals("members")) {
            ArrayList<String> hierarchy = this.contextNameHierarchy();
            Object[] expected = new String[]{"body", "module"};
            if (hierarchy.size() >= 2 && (Arrays.equals(hierarchy.subList(0, 2).toArray(), expected) || hierarchy.size() >= 3 && Arrays.equals(hierarchy.subList(1, 3).toArray(), expected))) {
                this.contextClose("body");
                this.contextOpen("members");
            }
        }
        this.contextClose("members");
        super.end_module_stmt(label, endKeyword, moduleKeyword, id, eos);
    }

    public void module_subprogram(boolean hasPrefix) {
        super.module_subprogram(hasPrefix);
    }

    public void use_stmt(Token label, Token useKeyword, Token id, Token onlyKeyword, Token eos, boolean hasModuleNature, boolean hasRenameList, boolean hasOnly) {
        if (this.context.getTagName().equals("declaration")) {
            this.contextClose("declaration");
        }
        if (!this.context.getTagName().equals("use")) {
            this.contextOpen("use");
        }
        this.setAttribute("name", id);
        super.use_stmt(label, useKeyword, id, onlyKeyword, eos, hasModuleNature, hasRenameList, hasOnly);
        this.contextClose("use");
        this.contextOpen("declaration");
    }

    public void rename_list__begin() {
        if (this.context.getTagName().equals("declaration")) {
            this.contextClose("declaration");
        }
        this.contextOpen("use");
        this.contextOpen("rename");
        if (this.verbosity >= 100) {
            super.rename_list__begin();
        }
    }

    public void rename_list(int count) {
        super.rename_list(count);
        this.contextClose("rename");
    }

    public void only_list__begin() {
        if (this.context.getTagName().equals("declaration")) {
            this.contextClose("declaration");
        }
        this.contextOpen("use");
        this.contextOpen("only");
        if (this.verbosity >= 100) {
            super.only_list__begin();
        }
    }

    public void only_list(int count) {
        super.only_list(count);
        this.contextClose("only");
    }

    public void block_data() {
        if (this.verbosity >= 100) {
            super.block_data();
        }
        this.contextClose("block-data");
    }

    public void block_data_stmt__begin() {
        this.contextOpen("block-data");
        if (this.verbosity >= 100) {
            super.block_data_stmt__begin();
        }
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void interface_block() {
        super.interface_block();
    }

    public void interface_specification() {
        super.interface_specification();
    }

    public void interface_stmt__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.contextOpen("interface");
        if (this.verbosity >= 100) {
            super.interface_stmt__begin();
        }
        this.contextOpen("header");
    }

    public void interface_stmt(Token label, Token abstractToken, Token keyword, Token eos, boolean hasGenericSpec) {
        if (this.contextTryFind("declaration") == null) {
            this.contextOpen("declaration");
        }
        if (this.contextTryFind("interface") == null) {
            this.contextOpen("interface");
            this.contextOpen("header");
        }
        this.contextClose("header");
        super.interface_stmt(label, abstractToken, keyword, eos, hasGenericSpec);
        if (abstractToken != null) {
            this.setAttribute("type", abstractToken);
        }
        this.contextOpen("body");
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void end_interface_stmt(Token label, Token kw1, Token kw2, Token eos, boolean hasGenericSpec) {
        this.contextCloseAllInner("interface");
        super.end_interface_stmt(label, kw1, kw2, eos, hasGenericSpec);
        this.contextClose();
    }

    public void interface_body(boolean hasPrefix) {
        super.interface_body(hasPrefix);
    }

    public void generic_spec(Token keyword, Token name, int type) {
        this.contextOpen("name");
        this.setAttribute("id", name);
        super.generic_spec(keyword, name, type);
        this.contextClose();
    }

    public void import_stmt(Token label, Token importKeyword, Token eos, boolean hasGenericNameList) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "import");
        super.import_stmt(label, importKeyword, eos, hasGenericNameList);
        this.contextClose("declaration");
    }

    public void external_stmt(Token label, Token externalKeyword, Token eos) {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        if (this.verbosity >= 80) {
            super.external_stmt(label, externalKeyword, eos);
        }
        this.setAttribute("type", "external");
    }

    public void procedure_declaration_stmt(Token label, Token procedureKeyword, Token eos, boolean hasProcInterface, int count) {
        super.procedure_declaration_stmt(label, procedureKeyword, eos, hasProcInterface, count);
    }

    public void proc_decl(Token id, boolean hasNullInit) {
        this.contextOpen("procedure");
        this.setAttribute("name", id);
        if (this.verbosity >= 80) {
            super.proc_decl(id, hasNullInit);
        }
        this.contextClose();
    }

    public void proc_decl_list__begin() {
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "procedures");
        this.contextOpen("procedures");
        if (this.verbosity >= 100) {
            super.proc_decl_list__begin();
        }
    }

    public void proc_decl_list(int count) {
        this.contextCloseAllInner("procedures");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.proc_decl_list(count);
        }
        this.contextClose();
    }

    public void intrinsic_stmt(Token label, Token intrinsicKeyword, Token eos) {
        Element condition = this.contextNode(-1);
        if (!this.context.getTagName().equals("declaration")) {
            this.contextOpen("declaration");
        }
        this.setAttribute("type", "intrinsic");
        this.moveHere(condition);
        super.intrinsic_stmt(label, intrinsicKeyword, eos);
    }

    public void call_stmt(Token label, Token callKeyword, Token eos, boolean hasActualArgSpecList) {
        Element name = this.contextNode(-1);
        Element arguments = null;
        if (name.getTagName() == "arguments") {
            arguments = name;
            name = this.contextNode(-2);
        } else if (name.getTagName() != "name") {
            this.cleanUpAfterError("tag name is not 'name' but '" + name.getTagName() + "'");
        }
        this.contextOpen("call");
        this.moveHere(name);
        if (arguments != null) {
            this.moveHere(arguments);
        }
        super.call_stmt(label, callKeyword, eos, hasActualArgSpecList);
        this.contextClose();
    }

    public void procedure_designator() {
        if (this.verbosity >= 100) {
            super.procedure_designator();
        }
        this.setAttribute("type", "procedure");
        this.contextClose("name");
    }

    public void actual_arg_spec(Token keyword) {
        boolean inArgumentContext;
        boolean bl = inArgumentContext = this.contextTryFind("argument") != null;
        if (!inArgumentContext) {
            this.contextOpen("argument");
        }
        this.setAttribute("name", keyword);
        if (this.verbosity >= 100) {
            super.actual_arg_spec(keyword);
        }
        if (inArgumentContext) {
            this.contextClose("argument");
        }
    }

    public void actual_arg_spec_list__begin() {
        this.contextOpen("arguments");
        if (this.verbosity >= 100) {
            super.actual_arg_spec_list__begin();
        }
        this.contextOpen("argument");
    }

    public void actual_arg_spec_list(int count) {
        this.contextClose("argument");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.actual_arg_spec_list(count);
        }
        this.contextClose("arguments");
    }

    public void actual_arg(boolean hasExpr, Token label) {
        boolean inArgumentContext;
        boolean bl = inArgumentContext = this.contextTryFind("argument") != null;
        if (!inArgumentContext) {
            if (hasExpr) {
                Element element = this.contextNode(-1);
                this.contextOpen("argument");
                this.moveHere(element);
            } else {
                this.contextOpen("argument");
            }
        }
        if (this.verbosity >= 60) {
            super.actual_arg(hasExpr, label);
        }
        if (inArgumentContext) {
            this.contextClose("argument");
        }
    }

    public void function_subprogram(boolean hasExePart, boolean hasIntSubProg) {
        super.function_subprogram(hasExePart, hasIntSubProg);
        if (this.context.getTagName().equals("function")) {
            this.contextClose("function");
        }
    }

    public void function_stmt__begin() {
        this.contextOpen("function");
        this.contextOpen("header");
        if (this.verbosity >= 100) {
            super.function_stmt__begin();
        }
    }

    public void function_stmt(Token label, Token keyword, Token name, Token eos, boolean hasGenericNameList, boolean hasSuffix) {
        this.contextClose("header");
        super.function_stmt(label, keyword, name, eos, hasGenericNameList, hasSuffix);
        this.setAttribute("name", name);
        this.contextOpen("body");
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void prefix_spec(boolean isDecTypeSpec) {
        super.prefix_spec(isDecTypeSpec);
        if (isDecTypeSpec) {
            this.contextClose("declaration");
        }
    }

    public void end_function_stmt(Token label, Token keyword1, Token keyword2, Token name, Token eos) {
        this.contextCloseAllInner("function");
        super.end_function_stmt(label, keyword1, keyword2, name, eos);
    }

    public void subroutine_stmt__begin() {
        this.contextOpen("subroutine");
        this.contextOpen("header");
        if (this.verbosity >= 100) {
            super.subroutine_stmt__begin();
        }
    }

    public void subroutine_stmt(Token label, Token keyword, Token name, Token eos, boolean hasPrefix, boolean hasDummyArgList, boolean hasBindingSpec, boolean hasArgSpecifier) {
        super.subroutine_stmt(label, keyword, name, eos, hasPrefix, hasDummyArgList, hasBindingSpec, hasArgSpecifier);
        this.contextClose("header");
        this.setAttribute("name", name);
        this.contextOpen("body");
        this.contextOpen("specification");
        this.contextOpen("declaration");
    }

    public void dummy_arg(Token dummy) {
        this.contextOpen("argument");
        this.setAttribute("name", dummy);
        if (this.verbosity >= 100) {
            super.dummy_arg(dummy);
        }
        this.contextClose();
    }

    public void dummy_arg_list__begin() {
        this.contextOpen("arguments");
        if (this.verbosity >= 100) {
            super.dummy_arg_list__begin();
        }
    }

    public void dummy_arg_list(int count) {
        this.contextCloseAllInner("arguments");
        this.setAttribute("count", count);
        if (this.verbosity >= 100) {
            super.dummy_arg_list(count);
        }
        this.contextClose();
    }

    public void end_subroutine_stmt(Token label, Token keyword1, Token keyword2, Token name, Token eos) {
        this.contextCloseAllInner("subroutine");
        super.end_subroutine_stmt(label, keyword1, keyword2, name, eos);
        this.contextClose();
    }

    public void return_stmt(Token label, Token keyword, Token eos, boolean hasScalarIntExpr) {
        if (hasScalarIntExpr) {
            Element element = this.contextNode(-1);
            this.contextOpen("return");
            this.contextOpen("value");
            this.moveHere(element);
            this.contextClose();
        } else {
            this.contextOpen("return");
        }
        this.setAttribute("hasValue", hasScalarIntExpr);
        super.return_stmt(label, keyword, eos, hasScalarIntExpr);
        this.contextClose();
    }

    public void contains_stmt(Token label, Token keyword, Token eos) {
        ArrayList<String> hierarchy = this.contextNameHierarchy();
        boolean acceptedContext = false;
        if (hierarchy.size() >= 3) {
            Object[] hierarchyArray = hierarchy.subList(0, 3).toArray();
            for (String enclosingGroup : new String[]{"subroutine", "program", "module"}) {
                acceptedContext = Arrays.equals(hierarchyArray, new String[]{"statement", "body", enclosingGroup});
                if (acceptedContext) break;
            }
        }
        if (acceptedContext) {
            this.contextClose("body");
        }
        super.contains_stmt(label, keyword, eos);
        if (acceptedContext) {
            this.contextOpen("members");
        }
    }

    public void separate_module_subprogram(boolean hasExecutionPart, boolean hasInternalSubprogramPart) {
        super.separate_module_subprogram(hasExecutionPart, hasInternalSubprogramPart);
        this.contextClose("subroutine");
    }

    public void separate_module_subprogram__begin() {
        this.contextOpen("subroutine");
        super.separate_module_subprogram__begin();
        this.contextOpen("header");
    }

    public void mp_subprogram_stmt(Token label, Token moduleKeyword, Token procedureKeyword, Token name, Token eos) {
        this.contextClose("header");
        this.setAttribute("name", name);
        super.mp_subprogram_stmt(label, moduleKeyword, procedureKeyword, name, eos);
        this.contextOpen("body");
    }

    public void end_mp_subprogram_stmt(Token label, Token keyword1, Token keyword2, Token name, Token eos) {
        this.contextCloseAllInner("subroutine");
        super.end_mp_subprogram_stmt(label, keyword1, keyword2, name, eos);
    }

    public void start_of_file(String filename, String path) {
        if (this.contextTryFind("file") != null) {
            if (this.context.getTagName().equals("declaration")) {
                this.contextClose("declaration");
            }
            this.contextOpen("declaration");
            this.setAttribute("type", "include");
        }
        this.contextOpen("file");
        if (this.verbosity >= 100) {
            super.start_of_file(filename, path);
        }
        if (path.equals("ERROR_FILE_NOT_FOUND")) {
            this.setAttribute("path", filename);
        } else {
            this.setAttribute("path", path);
        }
    }

    public void end_of_file(String filename, String path) {
        this.contextCloseAllInner("file");
        if (this.verbosity >= 100) {
            super.end_of_file(filename, path);
        }
        this.contextClose();
    }

    public void next_token(Token tk) {
        System.err.println("next_token");
        System.err.println(tk);
    }
}

