# Generated by sila2.code_generator; sila2.__version__: 0.12.2
from __future__ import annotations

from abc import ABC, abstractmethod
from typing import TYPE_CHECKING, List

from sila2.server import FeatureImplementationBase, MetadataDict

if TYPE_CHECKING:
    from ...server import Server
    from .labconfigurationcontroller_types import ConfigureJobShop_Responses, LoadJobShopFromFile_Responses, Machine


class LabConfigurationControllerBase(FeatureImplementationBase, ABC):
    parent_server: Server

    def __init__(self, parent_server: Server):
        """
          This feature is used to configure the lab environment (called JobShop in this context),
        the scheduler can use to schedule processes on.
        """
        super().__init__(parent_server=parent_server)

    @abstractmethod
    def get_CurrentJobShop(self, *, metadata: MetadataDict) -> list[Machine]:
        """
        The currently used job-shop

        :param metadata: The SiLA Client Metadata attached to the call
        :return: The currently used job-shop
        """

    @abstractmethod
    def LoadJobShopFromFile(self, ConfigurationFile: str, *, metadata: MetadataDict) -> LoadJobShopFromFile_Responses:
        """
        Sets the Job-Shop (set of devices in the lab) for the scheduler.
        It will be kept until this method is called again. You can also use the ConfigureJobShop method which only uses
        basic types to achieve the same result.


        :param ConfigurationFile: A yaml file in a specific format describing what machines of which capabilities should be used to
          schedule experiments on. This should be the file content and not the file location.

        :param metadata: The SiLA Client Metadata attached to the call

        """

    @abstractmethod
    def ConfigureJobShop(self, JobShop: list[Machine], *, metadata: MetadataDict) -> ConfigureJobShop_Responses:
        """
        Sets the Job-Shop (set of devices in the lab) for the scheduler.
            It will be kept until this method is called again.


        :param JobShop: A list of machines/devices available in the job-shop/laboratory to schedule operations on.

        :param metadata: The SiLA Client Metadata attached to the call

        """
