"""Adding new market table and content tables.

Revision ID: 8b53c8e91507
Revises: 4056c087960a
Create Date: 2025-06-23 18:45:51.916364

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "8b53c8e91507"
down_revision: Union[str, Sequence[str], None] = "4056c087960a"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "content_type",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=30), nullable=False),
        sa.Column("description", sa.String(length=1000), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "provider_asset_market",
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("provider_id", sa.Integer(), nullable=False),
        sa.Column("asset_id", sa.Integer(), nullable=False),
        sa.Column("close", sa.Float(), nullable=True, comment="Closing price"),
        sa.Column("open", sa.Float(), nullable=True, comment="Opening price"),
        sa.Column("high", sa.Float(), nullable=True, comment="Highest price"),
        sa.Column("low", sa.Float(), nullable=True, comment="Lowest price"),
        sa.Column("volume", sa.Float(), nullable=True, comment="Volume traded"),
        sa.Column("best_bid", sa.Float(), nullable=True, comment="Best bid price"),
        sa.Column("best_ask", sa.Float(), nullable=True, comment="Best ask price"),
        sa.ForeignKeyConstraint(
            ["asset_id"],
            ["asset.id"],
        ),
        sa.ForeignKeyConstraint(
            ["provider_id"],
            ["provider.id"],
        ),
        sa.PrimaryKeyConstraint("timestamp", "provider_id", "asset_id"),
    )
    op.create_table(
        "provider_content",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("provider_id", sa.Integer(), nullable=False),
        sa.Column("provider_unique_identifier", sa.String(length=1000), nullable=False),
        sa.Column("content_type_id", sa.Integer(), nullable=False),
        sa.Column("author", sa.String(length=100), nullable=True),
        sa.Column("title", sa.String(length=200), nullable=True),
        sa.Column("content", sa.String(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["content_type_id"],
            ["content_type.id"],
        ),
        sa.ForeignKeyConstraint(
            ["provider_id"],
            ["provider.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "asset_content",
        sa.Column("content_id", sa.Integer(), nullable=False),
        sa.Column("asset_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["asset_id"],
            ["asset.id"],
        ),
        sa.ForeignKeyConstraint(
            ["content_id"],
            ["provider_content.id"],
        ),
        sa.PrimaryKeyConstraint("content_id", "asset_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("asset_content")
    op.drop_table("provider_content")
    op.drop_table("provider_asset_market")
    op.drop_table("content_type")
    # ### end Alembic commands ###
