#!/usr/bin/env ts-node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const console = require("console");
const path = require("path");
const process = require("process");
const fs = require("fs-extra");
const cdk_1 = require("projen/lib/cdk");
// The directory where our 'package.json' lives
const MONOPACKAGE_ROOT = process.cwd();
const ROOT_PATH = findWorkspacePath();
const LIBRARIES_ROOT = path.resolve(ROOT_PATH, "packages");
const UBER_PACKAGE_JSON_PATH = path.join(MONOPACKAGE_ROOT, "package.json");
const EXCLUDED_PACKAGES = [];
async function main() {
    console.log(`🌴  workspace root path is: ${ROOT_PATH}`);
    const uberPackageJson = (await fs.readJson(UBER_PACKAGE_JSON_PATH));
    const libraries = await findLibrariesToPackage(uberPackageJson);
    await verifyDependencies(uberPackageJson, libraries);
    await prepareSourceFiles(libraries, uberPackageJson);
}
main().then(() => process.exit(0), (err) => {
    console.error("❌ An error occurred: ", err.stack);
    process.exit(1);
});
/**
 * Find the workspace root path. Walk up the directory tree until you find nx.json
 */
function findWorkspacePath() {
    return _findRootPath(process.cwd());
    function _findRootPath(part) {
        if (part === path.resolve(part, "..")) {
            throw new Error("couldn't find a 'nx.json' file when walking up the directory tree, are you in a aws-pdk project?");
        }
        if (fs.existsSync(path.resolve(part, "nx.json"))) {
            return part;
        }
        return _findRootPath(path.resolve(part, ".."));
    }
}
async function findLibrariesToPackage(uberPackageJson) {
    console.log("🔍 Discovering libraries that need packaging...");
    const deprecatedPackages = uberPackageJson.bundle?.deprecatedPackages;
    const result = new Array();
    for (const dir of await fs.readdir(LIBRARIES_ROOT)) {
        const packageJsonPath = path.resolve(LIBRARIES_ROOT, dir, "package.json");
        if (!fs.pathExistsSync(packageJsonPath)) {
            continue;
        }
        const packageJson = (await fs.readJson(packageJsonPath));
        if (packageJson.bundle?.exclude ||
            EXCLUDED_PACKAGES.includes(packageJson.name)) {
            console.log(`\t⚠️ Skipping (bundle excluded):    ${packageJson.name}`);
            continue;
        }
        else if (packageJson.jsii == null) {
            console.log(`\t⚠️ Skipping (not jsii-enabled):   ${packageJson.name}`);
            continue;
        }
        else if (deprecatedPackages?.some((packageName) => packageName === packageJson.name)) {
            console.log(`\t⚠️ Skipping (bundle deprecated): ${packageJson.name}`);
            continue;
        }
        else if (packageJson.deprecated) {
            console.log(`\t⚠️ Skipping (deprecated):         ${packageJson.name}`);
            continue;
        }
        else if (packageJson.stability !== cdk_1.Stability.STABLE) {
            console.log(`\t⚠️ Skipping (non stable):         ${packageJson.name}`);
            continue;
        }
        result.push({
            packageJson,
            root: path.join(LIBRARIES_ROOT, dir),
            shortName: packageJson.name === "aws-prototyping-sdk"
                ? packageJson.name
                : packageJson.name.slice("@aws-prototyping-sdk/".length),
        });
    }
    console.log(`\tℹ️ Found ${result.length} relevant packages!`);
    return result;
}
async function verifyDependencies(packageJson, libraries) {
    console.log("🧐 Verifying dependencies are complete...");
    const toBundle = {};
    for (const library of libraries) {
        for (const depName of library.packageJson.bundleDependencies ??
            library.packageJson.bundledDependencies ??
            []) {
            const requiredVersion = library.packageJson.devDependencies?.[depName] ??
                library.packageJson.dependencies?.[depName] ??
                "*";
            if (toBundle[depName] != null && toBundle[depName] !== requiredVersion) {
                throw new Error(`Required to bundle different versions of ${depName}: ${toBundle[depName]} and ${requiredVersion}.`);
            }
            toBundle[depName] = requiredVersion;
        }
    }
    const spuriousBundledDeps = new Set(packageJson.bundledDependencies ?? []);
    for (const [name, version] of Object.entries(toBundle)) {
        spuriousBundledDeps.delete(name);
        if (!packageJson.bundledDependencies?.includes(name)) {
            throw new Error(`\t⚠️ Missing bundled dependency: ${name} at ${version}`);
        }
        if (packageJson.dependencies?.[name] !== version) {
            throw new Error(`\t⚠️ Missing or incorrect dependency: ${name} at ${version}`);
        }
    }
    packageJson.bundledDependencies = packageJson.bundledDependencies?.filter((dep) => !spuriousBundledDeps.has(dep));
    if (spuriousBundledDeps.size > 0) {
        throw new Error(`\t⚠️ Spurious bundled dependencies detected. Please remove from dependencies: ${spuriousBundledDeps}`);
    }
    console.log("\t✅ Dependencies are correct!");
}
async function prepareSourceFiles(libraries, packageJson) {
    console.log("📝 Preparing source files...");
    const libRoot = resolveLibRoot(packageJson);
    // Should not remove collection directory if we're currently in it. The OS would be unhappy.
    if (libRoot !== process.cwd()) {
        await fs.remove(libRoot);
    }
    const indexStatements = new Array();
    for (const library of libraries) {
        const libDir = path.join(libRoot, library.shortName);
        const copied = await transformPackage(library, packageJson, libDir, libraries);
        if (!copied) {
            continue;
        }
        indexStatements.push(`export * as ${library.shortName.replace(/-/g, "_")} from './${library.shortName}';`);
    }
    await fs.writeFile(path.join(libRoot, "index.ts"), indexStatements.join("\n"), { encoding: "utf8" });
    console.log("\t🍺 Success!");
}
async function transformPackage(library, uberPackageJson, destination, allLibraries) {
    await fs.mkdirp(destination);
    await copyOrTransformFiles(library.root, destination, allLibraries, uberPackageJson);
    await fs.writeFile(path.join(destination, "index.ts"), `export * from './src';\n`, { encoding: "utf8" });
    const config = uberPackageJson.jsii.targets;
    await fs.writeJson(path.join(destination, ".jsiirc.json"), {
        targets: transformTargets(config, library.packageJson.jsii.targets),
    }, { spaces: 2 });
    // if libRoot is _not_ under the root of the package, generate a file at the
    // root that will refer to the one under lib/ so that users can still import
    // from "monocdk/aws-lambda".
    const relativeLibRoot = uberPackageJson.bundle?.libRoot;
    if (relativeLibRoot && relativeLibRoot !== ".") {
        await fs.writeFile(path.resolve(MONOPACKAGE_ROOT, `${library.shortName}.ts`), `export * from './${relativeLibRoot}/${library.shortName}';\n`, { encoding: "utf8" });
    }
    return true;
}
function transformTargets(monoConfig, targets) {
    if (targets == null) {
        return targets;
    }
    const result = {};
    for (const [language, config] of Object.entries(targets)) {
        switch (language) {
            case "dotnet":
                if (monoConfig?.dotnet != null) {
                    result[language] = {
                        namespace: config.namespace,
                    };
                }
                break;
            case "java":
                if (monoConfig?.java != null) {
                    result[language] = {
                        package: config.package,
                    };
                }
                break;
            case "python":
                if (monoConfig?.python != null) {
                    result[language] = {
                        module: `${monoConfig.python.module}.${config.module.replace(/^aws_prototyping_sdk\./, "")}`,
                    };
                }
                break;
            default:
                throw new Error(`Unsupported language for submodule configuration translation: ${language}`);
        }
    }
    return result;
}
async function copyOrTransformFiles(from, to, libraries, uberPackageJson) {
    const promises = (await fs.readdir(from)).map(async (name) => {
        if (shouldIgnoreFile(name)) {
            return;
        }
        if (name.endsWith(".d.ts") || name.endsWith(".js")) {
            if (await fs.pathExists(path.join(from, name.replace(/\.(d\.ts|js)$/, ".ts")))) {
                // We won't copy .d.ts and .js files with a corresponding .ts file
                return;
            }
        }
        const source = path.join(from, name);
        const destination = path.join(to, name);
        const stat = await fs.stat(source);
        if (stat.isDirectory()) {
            await fs.mkdirp(destination);
            return copyOrTransformFiles(source, destination, libraries, uberPackageJson);
        }
        if (name.endsWith(".ts")) {
            const sourceCode = fs
                .readFileSync(source)
                .toString()
                .replace(/(import .* from ["'])@aws-prototyping-sdk(\/.*['"];)/g, `$1${path.relative(path.dirname(destination), path.join(LIBRARIES_ROOT, "aws-prototyping-sdk"))}$2`);
            return fs.writeFile(destination, sourceCode);
        }
        else {
            return fs.copyFile(source, destination);
        }
    });
    await Promise.all(promises);
}
const IGNORED_FILE_NAMES = new Set([
    ".eslintrc.js",
    ".gitignore",
    ".jest.config.js",
    ".jsii",
    ".env",
    "target",
    "dist",
    "lib",
    "scripts",
    "test",
    ".npmignore",
    "node_modules",
    "package.json",
    "tsconfig.json",
    "tsconfig.tsbuildinfo",
    "LICENSE",
    "NOTICE",
]);
function shouldIgnoreFile(name) {
    return IGNORED_FILE_NAMES.has(name);
}
/**
 * Resolves the directory where we're going to collect all the libraries.
 *
 * By default, this is purposely the same as the monopackage root so that our
 * two import styles resolve to the same files but it can be overridden by
 * seeting `bundle.libRoot` in the package.json of the uber package.
 *
 * @param uberPackageJson package.json contents of the uber package
 * @returns The directory where we should collect all the libraries.
 */
function resolveLibRoot(uberPackageJson) {
    return path.resolve(uberPackageJson.bundle?.libRoot ?? MONOPACKAGE_ROOT);
}
//# sourceMappingURL=data:application/json;base64,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