# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ListDNSRecordsRequest(JDCloudRequest):
    """
    列出、搜索、排序和筛选域的DNS记录。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ListDNSRecordsRequest, self).__init__(
            '/zones/{zone_identifier}/dns_records', 'GET', header, version)
        self.parameters = parameters


class ListDNSRecordsParameters(object):

    def __init__(self, zone_identifier, ):
        """
        :param zone_identifier: 
        """

        self.zone_identifier = zone_identifier
        self.match = None
        self.name = None
        self.order = None
        self.page = None
        self.per_page = None
        self.content = None
        self.type = None
        self.proxied = None
        self.direction = None

    def setMatch(self, match):
        """
        :param match: (Optional) 是否匹配所有搜索要求或至少一个（任何）
        """
        self.match = match

    def setName(self, name):
        """
        :param name: (Optional) DNS record name
        """
        self.name = name

    def setOrder(self, order):
        """
        :param order: (Optional) 用于排序的字段
        """
        self.order = order

    def setPage(self, page):
        """
        :param page: (Optional) 分页结果的页码
        """
        self.page = page

    def setPer_page(self, per_page):
        """
        :param per_page: (Optional) 每页的DNS记录数
        """
        self.per_page = per_page

    def setContent(self, content):
        """
        :param content: (Optional) DNS记录内容
        """
        self.content = content

    def setType(self, type):
        """
        :param type: (Optional) DNS记录类型
        """
        self.type = type

    def setProxied(self, proxied):
        """
        :param proxied: (Optional) DNS记录代理状态
        """
        self.proxied = proxied

    def setDirection(self, direction):
        """
        :param direction: (Optional) asc - 升序；desc - 降序
        """
        self.direction = direction

