# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class Listener(object):

    def __init__(self, listenerId=None, listenerName=None, status=None, loadBalancerId=None, loadBalancerType=None, protocol=None, hstsEnable=None, hstsMaxAge=None, port=None, action=None, backendId=None, urlMapId=None, connectionIdleTimeSeconds=None, certificateSpecs=None, description=None, createdTime=None, extensionCertificateSpecs=None):
        """
        :param listenerId: (Optional) Listener的Id
        :param listenerName: (Optional) Listener的名称
        :param status: (Optional) Listener状态, 取值为On或者为Off
        :param loadBalancerId: (Optional) Listener所属loadBalancer的Id
        :param loadBalancerType: (Optional) Listener所属负载均衡类型，取值为：alb、nlb、dnlb
        :param protocol: (Optional) 监听协议, 取值为Tcp, Tls, Http, Https, Udp <br>【alb】支持Http, Https, Tcp, Tls和Udp <br>【nlb】支持Tcp, Udp  <br>【dnlb】支持Tcp, Udp
        :param hstsEnable: (Optional) 【alb使用https时支持】是否开启HSTS，True(开启)， False(关闭)
        :param hstsMaxAge: (Optional) 【alb使用https时支持】HSTS过期时间(秒)，取值范围为[1, 94608000(3年)]
        :param port: (Optional) 监听端口，取值范围为[1, 65535]
        :param action: (Optional) 默认后端服务的转发策略,取值为Forward或Redirect, 现只支持Forward
        :param backendId: (Optional) 默认的后端服务Id
        :param urlMapId: (Optional) 【alb Https和Http协议】转发规则组Id
        :param connectionIdleTimeSeconds: (Optional) 【alb、nlb】空闲连接超时时间, 范围为[1,86400]。 <br>（Tcp和Tls协议）默认为：1800s <br>（Udp协议）默认为：300s <br>（Http和Https协议）默认为：60s <br>【dnlb】不支持
        :param certificateSpecs: (Optional) 【alb Https和Tls协议】Listener绑定的默认证书，最多支持两个，两个证书的加密算法需要不同
        :param description: (Optional) Listener的描述信息
        :param createdTime: (Optional) Listener的创建时间
        :param extensionCertificateSpecs: (Optional) 【alb Https和Tls协议】Listener绑定的扩展证书列表
        """

        self.listenerId = listenerId
        self.listenerName = listenerName
        self.status = status
        self.loadBalancerId = loadBalancerId
        self.loadBalancerType = loadBalancerType
        self.protocol = protocol
        self.hstsEnable = hstsEnable
        self.hstsMaxAge = hstsMaxAge
        self.port = port
        self.action = action
        self.backendId = backendId
        self.urlMapId = urlMapId
        self.connectionIdleTimeSeconds = connectionIdleTimeSeconds
        self.certificateSpecs = certificateSpecs
        self.description = description
        self.createdTime = createdTime
        self.extensionCertificateSpecs = extensionCertificateSpecs
