# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeResourceTypeListRequest(JDCloudRequest):
    """
    查询支持的资源列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeResourceTypeListRequest, self).__init__(
            '/regions/{regionId}/resourcetypes', 'GET', header, version)
        self.parameters = parameters


class DescribeResourceTypeListParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 地域 ID
        """

        self.regionId = regionId
        self.pageNumber = None
        self.pageSize = None
        self.product = None
        self.search = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 当前所在页，默认为1
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 页面大小，默认为20；取值范围[1, 100]
        """
        self.pageSize = pageSize

    def setProduct(self, product):
        """
        :param product: (Optional) 产品线类型，比如 VM
        """
        self.product = product

    def setSearch(self, search):
        """
        :param search: (Optional) 搜索的内容
        """
        self.search = search

