# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateProductRequest(JDCloudRequest):
    """
    修改产品
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(UpdateProductRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/products/{productKey}', 'PATCH', header, version)
        self.parameters = parameters


class UpdateProductParameters(object):

    def __init__(self, regionId, instanceId, productKey, ):
        """
        :param regionId: 地域ID
        :param instanceId: IoT Engine实例ID信息
        :param productKey: 产品Key
        """

        self.regionId = regionId
        self.instanceId = instanceId
        self.productKey = productKey
        self.productName = None
        self.productDescription = None
        self.dynamicRegister = None

    def setProductName(self, productName):
        """
        :param productName: (Optional) 产品名称，名称不可为空，3-30个字符，只支持汉字、英文字母、数字、下划线“_”及中划线“-”，必须以汉字、英文字母及数字开头结尾
        """
        self.productName = productName

    def setProductDescription(self, productDescription):
        """
        :param productDescription: (Optional) 产品描述，80字符以内
        """
        self.productDescription = productDescription

    def setDynamicRegister(self, dynamicRegister):
        """
        :param dynamicRegister: (Optional) 动态注册,0:关闭，1:开启
        """
        self.dynamicRegister = dynamicRegister

