# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GetExportDataIdRequest(JDCloudRequest):
    """
    获取数据导出Id
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GetExportDataIdRequest, self).__init__(
            '/regions/{regionId}/console:getExportDataId', 'POST', header, version)
        self.parameters = parameters


class GetExportDataIdParameters(object):

    def __init__(self, regionId,):
        """
        :param regionId: 地域代码，取值范围参见[《各地域及可用区对照表》](../Enum-Definitions/Regions-AZ.md)
        """

        self.regionId = regionId
        self.dataSourceId = None
        self.sql = None
        self.dbName = None
        self.count = None
        self.ignoreCheck = None
        self.reason = None
        self.charset = None
        self.exportTypeEnum = None
        self.exportFileTypeEnum = None

    def setDataSourceId(self, dataSourceId):
        """
        :param dataSourceId: (Optional) 数据源id
        """
        self.dataSourceId = dataSourceId

    def setSql(self, sql):
        """
        :param sql: (Optional) 导出数据的查询sql
        """
        self.sql = sql

    def setDbName(self, dbName):
        """
        :param dbName: (Optional) 数据库名称
        """
        self.dbName = dbName

    def setCount(self, count):
        """
        :param count: (Optional) 导出数量
        """
        self.count = count

    def setIgnoreCheck(self, ignoreCheck):
        """
        :param ignoreCheck: (Optional) 是否跳过检测
        """
        self.ignoreCheck = ignoreCheck

    def setReason(self, reason):
        """
        :param reason: (Optional) 跳过行数检测原因
        """
        self.reason = reason

    def setCharset(self, charset):
        """
        :param charset: (Optional) 导出文件字符编码
        """
        self.charset = charset

    def setExportTypeEnum(self, exportTypeEnum):
        """
        :param exportTypeEnum: (Optional) 导出方式，SYNC("SYNC", 0), ASYNC("ASYNC", 1)，当前只支持SYNC导出;
        """
        self.exportTypeEnum = exportTypeEnum

    def setExportFileTypeEnum(self, exportFileTypeEnum):
        """
        :param exportFileTypeEnum: (Optional) 导出文件格式，CSV("CSV", 0), SQL("SQL", 1);
        """
        self.exportFileTypeEnum = exportFileTypeEnum

