# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class CreateProbeTaskParam(object):

    def __init__(self, address, name, probeType, probes, taskType, httpBody=None, httpCookie=None, httpHeader=None, httpType=None, port=None, targetId=None, targetRegion=None):
        """
        :param address:  探测地址，探测类型为http：内容为url（校验http或https头）；探测类型为telnet：内容为ip或域名（只允许中英文 、数字、中划线（-）、小数点（.）、开头及结尾均不能含有“-”）
        :param httpBody: (Optional) http body：选择探测类型为1=http时有效，最长不超过1024字节
in: query
        :param httpCookie: (Optional) http cookie：选择探测类型为1=http时有效，最大允许20个key、value对，最长不超过1024字节
        :param httpHeader: (Optional) http header：选择探测类型为1=http时有效，最大允许20个key、value对，最长不超过1024字节
        :param httpType: (Optional) http探测方法：选择探测类型为1=http时有效，默认值为1=get，可选值：1:get、2:post、3:head
        :param name:  task名称，不允许重复，长度不超过32字符，只允许中英文、数字、下划线_、中划线-, [0-9][a-z] [A-Z] [- _ ]
        :param port: (Optional) 探测端口，探测类型为telnet时必填，取值范围 [1-65535]，http类型忽略该参数
in: query
        :param probeType:  探测类型：1=http、2=telnet
        :param probes:  探测源（发起对探测目标探测的云主机，需安装相应的agent才能探测）
        :param targetId: (Optional) 探测目标id：该探测对象的uuid，任务类型为2：rds、3：redis时必填，
        :param targetRegion: (Optional) 探测目标region：该探测对象所在region，任务类型为2：rds、3：redis时必填
in: query
        :param taskType:  task类型：1=url/ip、2=RDS、3=redis
        """

        self.address = address
        self.httpBody = httpBody
        self.httpCookie = httpCookie
        self.httpHeader = httpHeader
        self.httpType = httpType
        self.name = name
        self.port = port
        self.probeType = probeType
        self.probes = probes
        self.targetId = targetId
        self.targetRegion = targetRegion
        self.taskType = taskType
