# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateWebProtectSettingsRequest(JDCloudRequest):
    """
    设置web防护开关
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(UpdateWebProtectSettingsRequest, self).__init__(
            '/domain/{domain}/wafWebProtectSettings', 'POST', header, version)
        self.parameters = parameters


class UpdateWebProtectSettingsParameters(object):

    def __init__(self, domain,):
        """
        :param domain: 用户域名
        """

        self.domain = domain
        self.wafMode = None
        self.wafLevel = None
        self.redirection = None

    def setWafMode(self, wafMode):
        """
        :param wafMode: (Optional) 0：拦截模式 (阻断forbidden 493跳到自定义页面) ，1-检测模式(观察notice)
        """
        self.wafMode = wafMode

    def setWafLevel(self, wafLevel):
        """
        :param wafLevel: (Optional) 规则策略等级 0为宽松, 1为正常, 2为严格
        """
        self.wafLevel = wafLevel

    def setRedirection(self, redirection):
        """
        :param redirection: (Optional) 拦截模式跳转的自定义页面名称, 缺省或default返回默认页面
        """
        self.redirection = redirection

