# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class SetSourceRequest(JDCloudRequest):
    """
    设置源站信息
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(SetSourceRequest, self).__init__(
            '/domain/{domain}/source', 'POST', header, version)
        self.parameters = parameters


class SetSourceParameters(object):

    def __init__(self, domain,):
        """
        :param domain: 用户域名
        """

        self.domain = domain
        self.sourceType = None
        self.backSourceType = None
        self.accelerateRegion = None
        self.ipSource = None
        self.domainSource = None
        self.ossSource = None
        self.defaultSourceHost = None

    def setSourceType(self, sourceType):
        """
        :param sourceType: (Optional) 回源类型只能是[ips,domain,oss]中的一种
        """
        self.sourceType = sourceType

    def setBackSourceType(self, backSourceType):
        """
        :param backSourceType: (Optional) 回源方式,只能是[https,http]中的一种,默认http
        """
        self.backSourceType = backSourceType

    def setAccelerateRegion(self, accelerateRegion):
        """
        :param accelerateRegion: (Optional) 加速区域,必须是[mainland,nonMainland,all]中的一种,分别代表大陆,海外+中国港澳台,全球
        """
        self.accelerateRegion = accelerateRegion

    def setIpSource(self, ipSource):
        """
        :param ipSource: (Optional) 
        """
        self.ipSource = ipSource

    def setDomainSource(self, domainSource):
        """
        :param domainSource: (Optional) 
        """
        self.domainSource = domainSource

    def setOssSource(self, ossSource):
        """
        :param ossSource: (Optional) oss回源域名
        """
        self.ossSource = ossSource

    def setDefaultSourceHost(self, defaultSourceHost):
        """
        :param defaultSourceHost: (Optional) 默认回源host
        """
        self.defaultSourceHost = defaultSourceHost

