# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class QueryStatisticsTopIpRequest(JDCloudRequest):
    """
    查询TOP IP，仅可查询中国境内的相关信息
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(QueryStatisticsTopIpRequest, self).__init__(
            '/statistics:topIp', 'POST', header, version)
        self.parameters = parameters


class QueryStatisticsTopIpParameters(object):

    def __init__(self, ):
        """
        """

        self.startTime = None
        self.endTime = None
        self.domain = None
        self.subDomain = None
        self.size = None
        self.topBy = None

    def setStartTime(self, startTime):
        """
        :param startTime: (Optional) 查询起始时间,UTC时间，格式为:yyyy-MM-dd'T'HH:mm:ss'Z'，示例:2018-10-21T10:00:00Z
        """
        self.startTime = startTime

    def setEndTime(self, endTime):
        """
        :param endTime: (Optional) 查询截止时间,UTC时间，格式为:yyyy-MM-dd'T'HH:mm:ss'Z'，示例:2018-10-21T10:00:00Z
        """
        self.endTime = endTime

    def setDomain(self, domain):
        """
        :param domain: (Optional) 需要查询的域名, 必须为用户pin下有权限的域名
        """
        self.domain = domain

    def setSubDomain(self, subDomain):
        """
        :param subDomain: (Optional) 待查询的子域名,查询泛域名时，指定的子域名列表，多个用逗号分隔。非泛域名时，传入空即可
        """
        self.subDomain = subDomain

    def setSize(self, size):
        """
        :param size: (Optional) 查询的topN的条数，取值范围：1-100，默认为20
        """
        self.size = size

    def setTopBy(self, topBy):
        """
        :param topBy: (Optional) 排序依据,当前可选：pv,flow, 分别表示按pv、按流量topN ip，默认为"pv"
        """
        self.topBy = topBy

