# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeBWListRequest(JDCloudRequest):
    """
    获取黑白名单列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeBWListRequest, self).__init__(
            '/regions/{regionId}/blackwhite:list', 'GET', header, version)
        self.parameters = parameters


class DescribeBWListParameters(object):

    def __init__(self, regionId, ):
        """
        :param regionId: 实例所属的地域ID
        """

        self.regionId = regionId
        self.resourceType = None
        self.bwType = None
        self.size = None
        self.index = None

    def setResourceType(self, resourceType):
        """
        :param resourceType: (Optional) 数据类型，不传或者为空返回所有类型数据，ip-IP，phone-手机，addr-地址，card-身份，pin-账户，eid-设备
        """
        self.resourceType = resourceType

    def setBwType(self, bwType):
        """
        :param bwType: (Optional) 数据类型，不传或者为空返回所有类型数据，列表类型，black-黑名单，white-白名单
        """
        self.bwType = bwType

    def setSize(self, size):
        """
        :param size: (Optional) 页面大小，缺省为10
        """
        self.size = size

    def setIndex(self, index):
        """
        :param index: (Optional) 起始页，缺省为1
        """
        self.index = index

