# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeRevisionsRequest(JDCloudRequest):
    """
    查询修订版本列表
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DescribeRevisionsRequest, self).__init__(
            '/regions/{regionId}/apiGroups/{apiGroupId}/revision', 'GET', header, version)
        self.parameters = parameters


class DescribeRevisionsParameters(object):

    def __init__(self, regionId, apiGroupId, ):
        """
        :param regionId: 地域ID
        :param apiGroupId: 分组ID
        """

        self.regionId = regionId
        self.apiGroupId = apiGroupId
        self.pageNumber = None
        self.pageSize = None
        self.filters = None

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 页码, 默认为1, 取值范围：[1,∞)
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 分页大小，默认为20，取值范围：[10,100]
        """
        self.pageSize = pageSize

    def setFilters(self, filters):
        """
        :param filters: (Optional) revision - 修订版本号，精确匹配
environment - 发布环境，模糊匹配
revisionNote - 修订备注，精确匹配

        """
        self.filters = filters

