# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateRevisionRequest(JDCloudRequest):
    """
    创建修订版本
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateRevisionRequest, self).__init__(
            '/regions/{regionId}/apiGroups/{apiGroupId}/revision', 'POST', header, version)
        self.parameters = parameters


class CreateRevisionParameters(object):

    def __init__(self, regionId, apiGroupId, ):
        """
        :param regionId: 地域ID
        :param apiGroupId: 分组ID
        """

        self.regionId = regionId
        self.apiGroupId = apiGroupId
        self.revision = None
        self.baseRevision = None
        self.revisionNote = None

    def setRevision(self, revision):
        """
        :param revision: (Optional) 修订版本号，如果创建版本时传回修订版本，此为必填项
        """
        self.revision = revision

    def setBaseRevision(self, baseRevision):
        """
        :param baseRevision: (Optional) 基于此版本，如果创建版本时传回修订版本，此为必填项
        """
        self.baseRevision = baseRevision

    def setRevisionNote(self, revisionNote):
        """
        :param revisionNote: (Optional) 修订备注
        """
        self.revisionNote = revisionNote

