"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codestar_GitHubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.unsafeUnwrap(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_b = props.enableIssues) !== null && _b !== void 0 ? _b : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
_a = JSII_RTTI_SYMBOL_1;
GitHubRepository[_a] = { fqn: "@aws-cdk/aws-codestar.GitHubRepository", version: "1.159.0" };
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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