import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping#id UserMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * This clause specifies the options of the user mapping. The options typically define the actual user name and password of the mapping. Option names must be unique. The allowed option names and values are specific to the server's foreign-data wrapper
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping#options UserMapping#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * The name of an existing server for which the user mapping is to be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping#server_name UserMapping#server_name}
    */
    readonly serverName: string;
    /**
    * The name of an existing user that is mapped to foreign server. CURRENT_ROLE, CURRENT_USER, and USER match the name of the current user. When PUBLIC is specified, a so-called public mapping is created that is used when no user-specific mapping is applicable
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping#user_name UserMapping#user_name}
    */
    readonly userName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping postgresql_user_mapping}
*/
export declare class UserMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_user_mapping";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/user_mapping postgresql_user_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserMappingConfig
    */
    constructor(scope: Construct, id: string, config: UserMappingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
