import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Automatically drop objects that depend on the server (such as user mappings), and in turn all objects that depend on those objects. Drop RESTRICT is the default
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#drop_cascade Server#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * The name of the foreign-data wrapper that manages the server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#fdw_name Server#fdw_name}
    */
    readonly fdwName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#id Server#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * This clause specifies the options for the server. The options typically define the connection details of the server, but the actual names and values are dependent on the server's foreign-data wrapper
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#options Server#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * The name of the foreign server to be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#server_name Server#server_name}
    */
    readonly serverName: string;
    /**
    * The user name of the new owner of the foreign server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#server_owner Server#server_owner}
    */
    readonly serverOwner?: string;
    /**
    * Optional server type, potentially useful to foreign-data wrappers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#server_type Server#server_type}
    */
    readonly serverType?: string;
    /**
    * Optional server version, potentially useful to foreign-data wrappers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/server#server_version Server#server_version}
    */
    readonly serverVersion?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/server postgresql_server}
*/
export declare class Server extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/server postgresql_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerConfig
    */
    constructor(scope: Construct, id: string, config: ServerConfig);
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _fdwName?;
    get fdwName(): string;
    set fdwName(value: string);
    get fdwNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _serverOwner?;
    get serverOwner(): string;
    set serverOwner(value: string);
    resetServerOwner(): void;
    get serverOwnerInput(): string | undefined;
    private _serverType?;
    get serverType(): string;
    set serverType(value: string);
    resetServerType(): void;
    get serverTypeInput(): string | undefined;
    private _serverVersion?;
    get serverVersion(): string;
    set serverVersion(value: string);
    resetServerVersion(): void;
    get serverVersionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
