import requests

class SheetBaseClient:
    def __init__(self, url):
        self.url = url
    
    def search(self, query, limit=10):
        r = requests.get(f"{self.url}?q={query}", timeout=10)
        return r.json()
    
    def get_all(self, limit=100):
        r = requests.get(f"{self.url}?limit={limit}", timeout=10)
        return r.json()
