from setuptools import setup

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="sheetbase-langchain",
    version="1.0.0",
    author="Surprise Dev",
    author_email="charleslepoittevin34@gmail.com",
    description="Simple HTTP client for SheetBase - Use Google Sheets as a database",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/surprise-dev/sheetbase-langchain",
    py_modules=["sheetbase_langchain"],
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.8",
    install_requires=["requests>=2.31.0"],
    keywords="sheetbase google-sheets database http-client langchain ai",
)
