# SheetBase LangChain

🤖 **Simple HTTP client for SheetBase** - Use Google Sheets as a database with Python and AI agents.

## 🚀 Installation

```
pip install sheetbase-langchain
```

## 📖 Quick Start

```
from sheetbase_langchain import SheetBaseClient

# Initialize with your Apps Script URL
client = SheetBaseClient("https://script.google.com/macros/s/YOUR_ID/exec")

# Search for data
results = client.search("Wireless Mouse", limit=10)
print(results)

# Get all data
all_data = client.get_all(limit=100)
print(f"Found {all_data['count']} items")
```

## ✨ Features

- ✅ **No API Key Required** - Works with public Google Sheets URLs
- ✅ **Simple HTTP Interface** - Easy to use Python client
- ✅ **Fuzzy Search** - Smart keyword-based search
- ✅ **Full CRUD** - Create, Read, Update, Delete operations
- ✅ **LangChain Compatible** - Use with AI agents

## 🔗 Related Projects

- [n8n-nodes-sheetbase](https://www.npmjs.com/package/n8n-nodes-sheetbase) - n8n node for workflow automation
- [SheetBase Demo Sheet](https://docs.google.com/spreadsheets/d/1qqVkstHyAWsLXpjs2fJ-mHhLS_rItTrszsXtptKZNks/)

## 📧 Contact

**Author:** Surprise Dev  
**Email:** charleslepoittevin34@gmail.com

## 📄 License

MIT License - Copyright (c) 2025 Surprise Dev
