# User Server Agent（计算服务器端）

## 职责

注册到 Control Server，维持心跳；监听下行指令、调度任务、执行脚本；实时上报 GPU 指标、任务日志与结果。

## 目录结构

- `core/`：Agent 核心逻辑（任务模型、异步执行器、任务管理器、GPU 监控器）
- `cli/`：CLI 工具（主入口 `flowhive.py`）
- `config/`：预留的配置文件目录
- `scripts/`：辅助脚本（如 `demo_task_manager.py` 用于本地测试）
- `tests/`：Pytest 用例

## 本地开发

创建环境并安装依赖：
```bash
cd agent
py -m venv .venv
.\.venv\Scripts\activate
pip install -r requirements.txt
```

或者直接安装（如果已发布到 PyPI）：
```bash
pip install flowhive-agent -i https://pypi.org/simple/
```

### 手动测试 TaskManager

如需快速体验任务执行链路，可以直接运行示例脚本：

```bash
cd agent
python scripts/demo_task_manager.py
```

脚本默认会提交一个简单的 Python 命令。也可通过传参覆盖：

```bash
python scripts/demo_task_manager.py "python -c \"print('hi')\"" --timeout 10
```

执行完成后，可在 `agent_logs/` 目录查看 stdout/stderr。

### 连接 Control Server

Agent 现在通过 WebSocket 同 Control Server 通讯。完成依赖安装（`pip install websockets`），然后运行：

```
cd agent
# 1. 设置账户信息
python flowhive_agent/cli/flowhive.py config user.username "test"
python flowhive_agent/cli/flowhive.py config user.email "user@example.com"
python flowhive_agent/cli/flowhive.py config user.password "your-password"
python flowhive_agent/cli/flowhive.py config control_base_url "http://127.0.0.1:8001"
python flowhive_agent/cli/flowhive.py config label "your-label"

# 2. 验证配置
python flowhive_agent/cli/flowhive.py config

# 3. 启动 Agent
python flowhive_agent/cli/flowhive.py run
```

脚本会自动根据 `control_base_url` 的协议自动转换：
- `http://` → `ws://`（明文 WebSocket）
- `https://` → `wss://`（加密 WebSocket，推荐生产环境使用）

**生产环境配置示例**：
```bash
# 使用 HTTPS/WSS（推荐）
python flowhive_agent/cli/flowhive.py config control_base_url "https://your-control-server.com"
```

Agent 会自动使用 `wss://` 连接到 Control Server，确保通信安全。

## 关键模块

- **GPU 监控器 & Service**：`GPUMonitor` 基于 NVML 采集显存、利用率与进程显存占用，`GPUService` 作为单例门面被 TaskManager/控制面复用，确保任务管理器只负责注入监控引用、不直接承担指标查询职责。
- **FlowHive Scheduler**：复用现有显存阈值、优先级、最大并发、任务重试等能力。
- **任务执行器**：`subprocess` / `torchrun` / `bash`，支持环境变量注入、容器启动。
- **OOM 自愈 & 重试**：根据任务状态机，将失败任务重新入队或降级排队。
- **日志/指标上报**：多路复用通道，将 stdout/stderr 流式推送至 Control Server。
- **心跳服务**：1s~5s 周期报告 GPU 拓扑、进程、Agent 版本。

## License

This Agent component is licensed under the MIT License. See [LICENSE](./LICENSE) for details.

**Note**: This is only the Agent component. The Control Server and Web Client are proprietary software and not covered by this license.

