# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class VideoStreamSettings(object):

    def __init__(self, codec, rcmode=None, rateFactor=None, bitrate=None, frameRate=None, width=None, height=None):
        """
        :param codec:  视频编码。取值范围：h264、h265
        :param rcmode: (Optional) 码率控制模式。取值范围：
  crf - 恒定码率系数模式。设置此模式时，rateFactor 生效，bitrate 会被忽略
  abr - 平均码率模式。设置此模式时，bitrate 生效，rateFactor 会被忽略
默认值为 abr

        :param rateFactor: (Optional) 码率控制因子。取值范围：[0, 51]，支持2位小数的浮点数
当 codec 为 h264 时，默认值为 23；当 codec 为 h265 时，默认值为 28

        :param bitrate: (Optional) 视频码率。取值范围：[128, 10000]，单位为 Kbps

        :param frameRate: (Optional) 视频帧率。取值范围：[1, 60]，单位为 fps
未设置时，与源文件视频帧率保持一致

        :param width: (Optional) 视频输出宽度。取值范围：[128, 4096] 整数。单位为 px
未设置时，若 height 也未设置值，则 width 和 height 与原视频保持一致；若 height 设置值，则 width 按照原视频的分辨率等比缩放

        :param height: (Optional) 视频输出高度。取值范围：[128, 4096] 整数。单位为 px
未设置时，若 width 也未设置值，则 width 和 height 与原视频保持一致；若 width 设置值，则 height 按照原视频的分辨率等比缩放

        """

        self.codec = codec
        self.rcmode = rcmode
        self.rateFactor = rateFactor
        self.bitrate = bitrate
        self.frameRate = frameRate
        self.width = width
        self.height = height
