# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class PutRequest(JDCloudRequest):
    """
    自定义日志上报。
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(PutRequest, self).__init__(
            '/logtopics/{logtopicUID}:put', 'POST', header, version)
        self.parameters = parameters


class PutParameters(object):

    def __init__(self, logtopicUID, entries):
        """
        :param logtopicUID: 日志主题uid
        :param entries: 日志数据
        """

        self.logtopicUID = logtopicUID
        self.stream = None
        self.timestamp = None
        self.tags = None
        self.entries = entries

    def setStream(self, stream):
        """
        :param stream: (Optional) 全局 strean 日志流标识符（建议起能唯一界定一个文件的名字，如 /i-iqnvqpinkjiq/app.log），不传则写入default日志流中（会导致很多文件混合在一起，不推荐）
        """
        self.stream = stream

    def setTimestamp(self, timestamp):
        """
        :param timestamp: (Optional) 全局时间戳，UTC格式，最多支持到纳秒级别，不传入则取服务器时间。如 2019-04-08T03:08:04.437670934Z、2019-04-08T03:08:04Z、2019-04-08T03:08:04.123Z
        """
        self.timestamp = timestamp

    def setTags(self, tags):
        """
        :param tags: (Optional) 全局标签 map[string]string
        """
        self.tags = tags

