"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const pod = require("./pod");
const workload = require("./workload");
/**
 * A Job creates one or more Pods and ensures that a specified number of them successfully terminate. As pods successfully complete,
 * the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
 * Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
 * The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
 * You can also use a Job to run multiple Pods in parallel.
 */
class Job extends workload.Workload {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            restartPolicy: pod.RestartPolicy.NEVER,
            select: false,
            ...props,
        });
        this.resourceType = 'jobs';
        this.apiObject = new k8s.KubeJob(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.activeDeadline = props.activeDeadline;
        this.backoffLimit = props.backoffLimit;
        this.ttlAfterFinished = props.ttlAfterFinished;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            activeDeadlineSeconds: this.activeDeadline?.toSeconds(),
            backoffLimit: this.backoffLimit,
            ttlSecondsAfterFinished: this.ttlAfterFinished ? this.ttlAfterFinished.toSeconds() : undefined,
        };
    }
}
exports.Job = Job;
_a = JSII_RTTI_SYMBOL_1;
Job[_a] = { fqn: "cdk8s-plus-22.Job", version: "2.0.0-rc.63" };
//# sourceMappingURL=data:application/json;base64,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