"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const k8s = require("./imports/k8s");
/**
 * Utility class to implement the conversion between our API and the k8s action
 * structure. Used both for probes and handlers.
 *
 * @internal
 */
class Action {
    static fromTcpSocket(container, options = {}) {
        return {
            port: k8s.IntOrString.fromNumber(options.port ?? container.port ?? 80),
            host: options.host,
        };
    }
    static fromCommand(command) {
        return { command };
    }
    static fromHttpGet(container, path, options = {}) {
        return {
            path,
            port: k8s.IntOrString.fromNumber(options.port ?? container.port ?? 80),
        };
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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