# Generated by Django 4.1.2 on 2022-10-22 00:11

import django.contrib.postgres.fields.ranges
import django.contrib.postgres.indexes
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('tom_nonlocalizedevents', '0012_nonlocalizedevent_event_subtype'),
    ]

    operations = [
        migrations.AddField(
            model_name='eventcandidate',
            name='healpix',
            field=models.BigIntegerField(default=-1, help_text='Stores the healpix index for this candidates target, used for MOC lookups'),
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='nonlocalizedevent',
            field=models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name='localization', to='tom_nonlocalizedevents.nonlocalizedevent'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='eventlocalization',
            name='sequence_id',
            field=models.PositiveIntegerField(default=1),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='nonlocalizedevent',
            name='state',
            field=models.CharField(choices=[('ACTIVE', 'Active'), ('INACTIVE', 'Inactive'), ('RETRACTED', 'Retracted')], default='ACTIVE', help_text='The current state of this NonLocalizedEvent', max_length=16),
        ),
        migrations.AlterField(
            model_name='eventcandidate',
            name='nonlocalizedevent',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='candidates', to='tom_nonlocalizedevents.nonlocalizedevent'),
        ),
        migrations.CreateModel(
            name='SkymapTile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tile', django.contrib.postgres.fields.ranges.BigIntegerRangeField(db_index=True)),
                ('probdensity', models.FloatField()),
                ('localization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tiles', to='tom_nonlocalizedevents.eventlocalization')),
            ],
        ),
        migrations.AddIndex(
            model_name='skymaptile',
            index=django.contrib.postgres.indexes.SpGistIndex(fields=['tile'], name='tom_nonloca_tile_3cc24d_spgist'),
        ),
    ]
