# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Share(pulumi.CustomResource):
    all_metadata: pulumi.Output[dict]
    """
    The map of metadata, assigned on the share, which has been
    explicitly and implicitly added.
    """
    availability_zone: pulumi.Output[str]
    """
    The share availability zone. Changing this creates a
    new share.
    """
    description: pulumi.Output[str]
    """
    The human-readable description for the share.
    Changing this updates the description of the existing share.
    """
    export_locations: pulumi.Output[list]
    """
    A list of export locations. For example, when a share server
    has more than one network interface, it can have multiple export locations.

      * `path` (`str`)
      * `preferred` (`str`)
    """
    has_replicas: pulumi.Output[bool]
    """
    Indicates whether a share has replicas or not.
    """
    host: pulumi.Output[str]
    """
    The share host name.
    """
    is_public: pulumi.Output[bool]
    """
    The level of visibility for the share. Set to true to make
    share public. Set to false to make it private. Default value is false. Changing this
    updates the existing share.
    """
    metadata: pulumi.Output[dict]
    """
    One or more metadata key and value pairs as a dictionary of
    strings.
    """
    name: pulumi.Output[str]
    """
    The name of the share. Changing this updates the name
    of the existing share.
    """
    project_id: pulumi.Output[str]
    """
    The owner of the Share.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 Shared File System client.
    A Shared File System client is needed to create a share. Changing this
    creates a new share.
    """
    replication_type: pulumi.Output[str]
    """
    The share replication type.
    """
    share_network_id: pulumi.Output[str]
    """
    The UUID of a share network where the share server exists
    or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
    the share_network_id value from the snapshot is used. Changing this creates a new share.
    """
    share_proto: pulumi.Output[str]
    """
    The share protocol - can either be NFS, CIFS,
    CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
    """
    share_server_id: pulumi.Output[str]
    """
    The UUID of the share server.
    """
    share_type: pulumi.Output[str]
    """
    The share type name. If you omit this parameter, the default
    share type is used.
    """
    size: pulumi.Output[float]
    """
    The share size, in GBs. The requested share size cannot be greater
    than the allowed GB quota. Changing this resizes the existing share.
    """
    snapshot_id: pulumi.Output[str]
    """
    The UUID of the share's base snapshot. Changing this creates
    a new share.
    """
    def __init__(__self__, resource_name, opts=None, availability_zone=None, description=None, is_public=None, metadata=None, name=None, region=None, share_network_id=None, share_proto=None, share_type=None, size=None, snapshot_id=None, __props__=None, __name__=None, __opts__=None):
        """
        Use this resource to configure a share.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/sharedfilesystem_share_v2.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[dict] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Shared File System client.
               A Shared File System client is needed to create a share. Changing this
               creates a new share.
        :param pulumi.Input[str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[float] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['availability_zone'] = availability_zone
            __props__['description'] = description
            __props__['is_public'] = is_public
            __props__['metadata'] = metadata
            __props__['name'] = name
            __props__['region'] = region
            __props__['share_network_id'] = share_network_id
            if share_proto is None:
                raise TypeError("Missing required property 'share_proto'")
            __props__['share_proto'] = share_proto
            __props__['share_type'] = share_type
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['snapshot_id'] = snapshot_id
            __props__['all_metadata'] = None
            __props__['export_locations'] = None
            __props__['has_replicas'] = None
            __props__['host'] = None
            __props__['project_id'] = None
            __props__['replication_type'] = None
            __props__['share_server_id'] = None
        super(Share, __self__).__init__(
            'openstack:sharedfilesystem/share:Share',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, all_metadata=None, availability_zone=None, description=None, export_locations=None, has_replicas=None, host=None, is_public=None, metadata=None, name=None, project_id=None, region=None, replication_type=None, share_network_id=None, share_proto=None, share_server_id=None, share_type=None, size=None, snapshot_id=None):
        """
        Get an existing Share resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] all_metadata: The map of metadata, assigned on the share, which has been
               explicitly and implicitly added.
        :param pulumi.Input[str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[list] export_locations: A list of export locations. For example, when a share server
               has more than one network interface, it can have multiple export locations.
        :param pulumi.Input[bool] has_replicas: Indicates whether a share has replicas or not.
        :param pulumi.Input[str] host: The share host name.
        :param pulumi.Input[bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[dict] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[str] project_id: The owner of the Share.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Shared File System client.
               A Shared File System client is needed to create a share. Changing this
               creates a new share.
        :param pulumi.Input[str] replication_type: The share replication type.
        :param pulumi.Input[str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[str] share_server_id: The UUID of the share server.
        :param pulumi.Input[str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[float] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.

        The **export_locations** object supports the following:

          * `path` (`pulumi.Input[str]`)
          * `preferred` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["all_metadata"] = all_metadata
        __props__["availability_zone"] = availability_zone
        __props__["description"] = description
        __props__["export_locations"] = export_locations
        __props__["has_replicas"] = has_replicas
        __props__["host"] = host
        __props__["is_public"] = is_public
        __props__["metadata"] = metadata
        __props__["name"] = name
        __props__["project_id"] = project_id
        __props__["region"] = region
        __props__["replication_type"] = replication_type
        __props__["share_network_id"] = share_network_id
        __props__["share_proto"] = share_proto
        __props__["share_server_id"] = share_server_id
        __props__["share_type"] = share_type
        __props__["size"] = size
        __props__["snapshot_id"] = snapshot_id
        return Share(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

