# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Trunk(pulumi.CustomResource):
    admin_state_up: pulumi.Output[bool]
    """
    Administrative up/down status for the trunk
    (must be "true" or "false" if provided). Changing this updates the
    `admin_state_up` of an existing trunk.
    """
    all_tags: pulumi.Output[list]
    """
    The collection of tags assigned on the trunk, which have been
    explicitly and implicitly added.
    """
    description: pulumi.Output[str]
    """
    Human-readable description of the trunk. Changing this
    updates the name of the existing trunk.
    """
    name: pulumi.Output[str]
    """
    A unique name for the trunk. Changing this
    updates the `name` of an existing trunk.
    """
    port_id: pulumi.Output[str]
    """
    The ID of the port to be made a subport of the trunk.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 networking client.
    A networking client is needed to create a trunk. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    trunk.
    """
    sub_ports: pulumi.Output[list]
    """
    The set of ports that will be made subports of the trunk.
    The structure of each subport is described below.

      * `port_id` (`str`) - The ID of the port to be made a subport of the trunk.
      * `segmentation_id` (`float`) - The numeric id of the subport segment.
      * `segmentationType` (`str`) - The segmentation technology to use, e.g., "vlan".
    """
    tags: pulumi.Output[list]
    """
    A set of string tags for the port.
    """
    tenant_id: pulumi.Output[str]
    """
    The owner of the Trunk. Required if admin wants
    to create a trunk on behalf of another tenant. Changing this creates a new trunk.
    """
    def __init__(__self__, resource_name, opts=None, admin_state_up=None, description=None, name=None, port_id=None, region=None, sub_ports=None, tags=None, tenant_id=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a networking V2 trunk resource within OpenStack.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/r/networking_trunk_v2.html.markdown.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the trunk
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing trunk.
        :param pulumi.Input[str] description: Human-readable description of the trunk. Changing this
               updates the name of the existing trunk.
        :param pulumi.Input[str] name: A unique name for the trunk. Changing this
               updates the `name` of an existing trunk.
        :param pulumi.Input[str] port_id: The ID of the port to be made a subport of the trunk.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a trunk. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               trunk.
        :param pulumi.Input[list] sub_ports: The set of ports that will be made subports of the trunk.
               The structure of each subport is described below.
        :param pulumi.Input[list] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the Trunk. Required if admin wants
               to create a trunk on behalf of another tenant. Changing this creates a new trunk.

        The **sub_ports** object supports the following:

          * `port_id` (`pulumi.Input[str]`) - The ID of the port to be made a subport of the trunk.
          * `segmentation_id` (`pulumi.Input[float]`) - The numeric id of the subport segment.
          * `segmentationType` (`pulumi.Input[str]`) - The segmentation technology to use, e.g., "vlan".
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_state_up'] = admin_state_up
            __props__['description'] = description
            __props__['name'] = name
            if port_id is None:
                raise TypeError("Missing required property 'port_id'")
            __props__['port_id'] = port_id
            __props__['region'] = region
            __props__['sub_ports'] = sub_ports
            __props__['tags'] = tags
            __props__['tenant_id'] = tenant_id
            __props__['all_tags'] = None
        super(Trunk, __self__).__init__(
            'openstack:networking/trunk:Trunk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, admin_state_up=None, all_tags=None, description=None, name=None, port_id=None, region=None, sub_ports=None, tags=None, tenant_id=None):
        """
        Get an existing Trunk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the trunk
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing trunk.
        :param pulumi.Input[list] all_tags: The collection of tags assigned on the trunk, which have been
               explicitly and implicitly added.
        :param pulumi.Input[str] description: Human-readable description of the trunk. Changing this
               updates the name of the existing trunk.
        :param pulumi.Input[str] name: A unique name for the trunk. Changing this
               updates the `name` of an existing trunk.
        :param pulumi.Input[str] port_id: The ID of the port to be made a subport of the trunk.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a trunk. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               trunk.
        :param pulumi.Input[list] sub_ports: The set of ports that will be made subports of the trunk.
               The structure of each subport is described below.
        :param pulumi.Input[list] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the Trunk. Required if admin wants
               to create a trunk on behalf of another tenant. Changing this creates a new trunk.

        The **sub_ports** object supports the following:

          * `port_id` (`pulumi.Input[str]`) - The ID of the port to be made a subport of the trunk.
          * `segmentation_id` (`pulumi.Input[float]`) - The numeric id of the subport segment.
          * `segmentationType` (`pulumi.Input[str]`) - The segmentation technology to use, e.g., "vlan".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["admin_state_up"] = admin_state_up
        __props__["all_tags"] = all_tags
        __props__["description"] = description
        __props__["name"] = name
        __props__["port_id"] = port_id
        __props__["region"] = region
        __props__["sub_ports"] = sub_ports
        __props__["tags"] = tags
        __props__["tenant_id"] = tenant_id
        return Trunk(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

