# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class GetContainerResult:
    """
    A collection of values returned by getContainer.
    """
    def __init__(__self__, acls=None, consumers=None, container_ref=None, created_at=None, creator_id=None, id=None, name=None, region=None, secret_refs=None, status=None, type=None, updated_at=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        __self__.acls = acls
        """
        The list of ACLs assigned to a container. The `read` structure is
        described below.
        """
        if consumers and not isinstance(consumers, list):
            raise TypeError("Expected argument 'consumers' to be a list")
        __self__.consumers = consumers
        """
        The list of the container consumers. The structure is described
        below.
        """
        if container_ref and not isinstance(container_ref, str):
            raise TypeError("Expected argument 'container_ref' to be a str")
        __self__.container_ref = container_ref
        """
        The container reference / where to find the container.
        """
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        __self__.created_at = created_at
        """
        The date the container ACL was created.
        """
        if creator_id and not isinstance(creator_id, str):
            raise TypeError("Expected argument 'creator_id' to be a str")
        __self__.creator_id = creator_id
        """
        The creator of the container.
        """
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        __self__.id = id
        """
        id is the provider-assigned unique ID for this managed resource.
        """
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        __self__.name = name
        """
        The name of the consumer.
        """
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        __self__.region = region
        """
        See Argument Reference above.
        """
        if secret_refs and not isinstance(secret_refs, list):
            raise TypeError("Expected argument 'secret_refs' to be a list")
        __self__.secret_refs = secret_refs
        """
        A set of dictionaries containing references to secrets. The
        structure is described below.
        """
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        __self__.status = status
        """
        The status of the container.
        """
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        __self__.type = type
        """
        The container type.
        """
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        __self__.updated_at = updated_at
        """
        The date the container ACL was last updated.
        """
class AwaitableGetContainerResult(GetContainerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerResult(
            acls=self.acls,
            consumers=self.consumers,
            container_ref=self.container_ref,
            created_at=self.created_at,
            creator_id=self.creator_id,
            id=self.id,
            name=self.name,
            region=self.region,
            secret_refs=self.secret_refs,
            status=self.status,
            type=self.type,
            updated_at=self.updated_at)

def get_container(name=None,region=None,opts=None):
    """
    Use this data source to get the ID of an available Barbican container.

    > This content is derived from https://github.com/terraform-providers/terraform-provider-openstack/blob/master/website/docs/d/keymanager_container_v1.html.markdown.


    :param str name: The Container name.
    :param str region: The region in which to obtain the V1 KeyManager client.
           A KeyManager client is needed to fetch a container. If omitted, the `region`
           argument of the provider is used.
    """
    __args__ = dict()


    __args__['name'] = name
    __args__['region'] = region
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = utilities.get_version()
    __ret__ = pulumi.runtime.invoke('openstack:keymanager/getContainer:getContainer', __args__, opts=opts).value

    return AwaitableGetContainerResult(
        acls=__ret__.get('acls'),
        consumers=__ret__.get('consumers'),
        container_ref=__ret__.get('containerRef'),
        created_at=__ret__.get('createdAt'),
        creator_id=__ret__.get('creatorId'),
        id=__ret__.get('id'),
        name=__ret__.get('name'),
        region=__ret__.get('region'),
        secret_refs=__ret__.get('secretRefs'),
        status=__ret__.get('status'),
        type=__ret__.get('type'),
        updated_at=__ret__.get('updatedAt'))
