# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.notification_preference import NotificationPreference

class UserPreferencesSubscriptionNotifications(BaseModel):
    """
    UserPreferencesSubscriptionNotifications
    """
    long_term_auction_updates: NotificationPreference = Field(..., alias="longTermAuctionUpdates")
    buy_now_transmission_rights_offers: NotificationPreference = Field(..., alias="buyNowTransmissionRightsOffers")
    __properties = ["longTermAuctionUpdates", "buyNowTransmissionRightsOffers"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserPreferencesSubscriptionNotifications:
        """Create an instance of UserPreferencesSubscriptionNotifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of long_term_auction_updates
        if self.long_term_auction_updates:
            _dict['longTermAuctionUpdates'] = self.long_term_auction_updates.to_dict()
        # override the default output from pydantic by calling `to_dict()` of buy_now_transmission_rights_offers
        if self.buy_now_transmission_rights_offers:
            _dict['buyNowTransmissionRightsOffers'] = self.buy_now_transmission_rights_offers.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserPreferencesSubscriptionNotifications:
        """Create an instance of UserPreferencesSubscriptionNotifications from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserPreferencesSubscriptionNotifications.parse_obj(obj)

        _obj = UserPreferencesSubscriptionNotifications.parse_obj({
            "long_term_auction_updates": NotificationPreference.from_dict(obj.get("longTermAuctionUpdates")) if obj.get("longTermAuctionUpdates") is not None else None,
            "buy_now_transmission_rights_offers": NotificationPreference.from_dict(obj.get("buyNowTransmissionRightsOffers")) if obj.get("buyNowTransmissionRightsOffers") is not None else None
        })
        return _obj

