# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from empire_platform_api_public_client.models.submit_day_ahead_or_intra_day_bids_request_bid_groups_inner_bids_inner import SubmitDayAheadOrIntraDayBidsRequestBidGroupsInnerBidsInner

class SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner(BaseModel):
    """
    SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner
    """
    id: Optional[StrictStr] = Field(None, description="Unique (at least locally) identifier for the record in UUID4 format  * records received nullable identifiers through GET requests should have the property filled out * records sent to PUT endpoints:   - if property is filled out => backend is expected to update the record   - if property is null or missing => backend is expected to create a new record   - if list of records does not contain the record identifier => backend is expected to delete the record ")
    bids: conlist(SubmitDayAheadOrIntraDayBidsRequestBidGroupsInnerBidsInner) = Field(...)
    __properties = ["id", "bids"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner:
        """Create an instance of SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bids (list)
        _items = []
        if self.bids:
            for _item in self.bids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bids'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner:
        """Create an instance of SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner.parse_obj(obj)

        _obj = SubmitDayAheadOrIntraDayBidsRequestBidGroupsInner.parse_obj({
            "id": obj.get("id"),
            "bids": [SubmitDayAheadOrIntraDayBidsRequestBidGroupsInnerBidsInner.from_dict(_item) for _item in obj.get("bids")] if obj.get("bids") is not None else None
        })
        return _obj

