# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class OrganisationMarketSettingsGbNominationSettings(BaseModel):
    """
    OrganisationMarketSettingsGbNominationSettings
    """
    able_to_nominate: StrictBool = Field(..., alias="ableToNominate")
    bmu_demand_code: Optional[StrictStr] = Field(None, alias="bmuDemandCode")
    bmu_generation_code: Optional[StrictStr] = Field(None, alias="bmuGenerationCode")
    on_behalf_participant_id: Optional[StrictStr] = Field(None, alias="onBehalfParticipantId", description="Unique identifier for the record in UUID4 format")
    __properties = ["ableToNominate", "bmuDemandCode", "bmuGenerationCode", "onBehalfParticipantId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrganisationMarketSettingsGbNominationSettings:
        """Create an instance of OrganisationMarketSettingsGbNominationSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganisationMarketSettingsGbNominationSettings:
        """Create an instance of OrganisationMarketSettingsGbNominationSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OrganisationMarketSettingsGbNominationSettings.parse_obj(obj)

        _obj = OrganisationMarketSettingsGbNominationSettings.parse_obj({
            "able_to_nominate": obj.get("ableToNominate"),
            "bmu_demand_code": obj.get("bmuDemandCode"),
            "bmu_generation_code": obj.get("bmuGenerationCode"),
            "on_behalf_participant_id": obj.get("onBehalfParticipantId")
        })
        return _obj

