# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictStr, confloat, conint, conlist
from empire_platform_api_public_client.models.attachment import Attachment
from empire_platform_api_public_client.models.date_period import DatePeriod
from empire_platform_api_public_client.models.invoice_history import InvoiceHistory
from empire_platform_api_public_client.models.invoice_line_item import InvoiceLineItem
from empire_platform_api_public_client.models.invoice_participant_details import InvoiceParticipantDetails
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.invoice_summary import InvoiceSummary
from empire_platform_api_public_client.models.invoice_vat_rate import InvoiceVatRate

class InvoiceDetails(BaseModel):
    """
    InvoiceDetails
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(..., alias="displayId")
    participant: InvoiceParticipantDetails = Field(...)
    period: DatePeriod = Field(...)
    net_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="netAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    gross_amount: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="grossAmount", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    due_date: Optional[date] = Field(None, alias="dueDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    sent_date: Optional[date] = Field(None, alias="sentDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    paid_date: Optional[date] = Field(None, alias="paidDate", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    status: InvoiceStatus = Field(...)
    last_status_change: datetime = Field(..., alias="lastStatusChange", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    sendable: StrictBool = Field(...)
    line_items: conlist(InvoiceLineItem) = Field(..., alias="lineItems")
    vat_rates: conlist(InvoiceVatRate) = Field(..., alias="vatRates")
    summaries: conlist(InvoiceSummary) = Field(...)
    attachment: Optional[Attachment] = None
    history: conlist(InvoiceHistory) = Field(...)
    __properties = ["id", "displayId", "participant", "period", "netAmount", "grossAmount", "dueDate", "sentDate", "paidDate", "status", "lastStatusChange", "sendable", "lineItems", "vatRates", "summaries", "attachment", "history"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InvoiceDetails:
        """Create an instance of InvoiceDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period
        if self.period:
            _dict['period'] = self.period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lineItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vat_rates (list)
        _items = []
        if self.vat_rates:
            for _item in self.vat_rates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['vatRates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in summaries (list)
        _items = []
        if self.summaries:
            for _item in self.summaries:
                if _item:
                    _items.append(_item.to_dict())
            _dict['summaries'] = _items
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item in self.history:
                if _item:
                    _items.append(_item.to_dict())
            _dict['history'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InvoiceDetails:
        """Create an instance of InvoiceDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InvoiceDetails.parse_obj(obj)

        _obj = InvoiceDetails.parse_obj({
            "id": obj.get("id"),
            "display_id": obj.get("displayId"),
            "participant": InvoiceParticipantDetails.from_dict(obj.get("participant")) if obj.get("participant") is not None else None,
            "period": DatePeriod.from_dict(obj.get("period")) if obj.get("period") is not None else None,
            "net_amount": obj.get("netAmount"),
            "gross_amount": obj.get("grossAmount"),
            "due_date": obj.get("dueDate"),
            "sent_date": obj.get("sentDate"),
            "paid_date": obj.get("paidDate"),
            "status": obj.get("status"),
            "last_status_change": obj.get("lastStatusChange"),
            "sendable": obj.get("sendable"),
            "line_items": [InvoiceLineItem.from_dict(_item) for _item in obj.get("lineItems")] if obj.get("lineItems") is not None else None,
            "vat_rates": [InvoiceVatRate.from_dict(_item) for _item in obj.get("vatRates")] if obj.get("vatRates") is not None else None,
            "summaries": [InvoiceSummary.from_dict(_item) for _item in obj.get("summaries")] if obj.get("summaries") is not None else None,
            "attachment": Attachment.from_dict(obj.get("attachment")) if obj.get("attachment") is not None else None,
            "history": [InvoiceHistory.from_dict(_item) for _item in obj.get("history")] if obj.get("history") is not None else None
        })
        return _obj

