# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.179.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from datetime import date

from pydantic import Field, StrictStr, conlist

from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.transmission_rights_overview import TransmissionRightsOverview

from empire_platform_api_public_client.api_client import ApiClient
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TransmissionRightApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_transmission_rights_overview(self, delivery_day : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], mtu_size : Annotated[MtuSize, Field(..., description="MTU Size definition")], **kwargs) -> TransmissionRightsOverview:  # noqa: E501
        """get_transmission_rights_overview  # noqa: E501

        Fetch an filterable overview of Transmission Rights  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transmission_rights_overview(delivery_day, x_participant_ids, border_direction, timescales, mtu_size, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransmissionRightsOverview
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_transmission_rights_overview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_transmission_rights_overview_with_http_info(delivery_day, x_participant_ids, border_direction, timescales, mtu_size, **kwargs)  # noqa: E501

    @validate_arguments
    def get_transmission_rights_overview_with_http_info(self, delivery_day : date, x_participant_ids : Annotated[conlist(StrictStr), Field(..., description="List of internal IDs of Participant-type Organisations")], border_direction : Annotated[BorderDirectionWithBoth, Field(..., description="Border Direction with additional 'BOTH' option")], timescales : Annotated[conlist(AuctionTimescale), Field(..., description="List of Auction Timescales")], mtu_size : Annotated[MtuSize, Field(..., description="MTU Size definition")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_transmission_rights_overview  # noqa: E501

        Fetch an filterable overview of Transmission Rights  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transmission_rights_overview_with_http_info(delivery_day, x_participant_ids, border_direction, timescales, mtu_size, async_req=True)
        >>> result = thread.get()

        :param delivery_day: (required)
        :type delivery_day: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransmissionRightsOverview, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'delivery_day',
            'x_participant_ids',
            'border_direction',
            'timescales',
            'mtu_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transmission_rights_overview" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('delivery_day') is not None:  # noqa: E501
            if isinstance(_params['delivery_day'], datetime):
                _query_params.append(('deliveryDay', _params['delivery_day'].strftime(self.api_client.configuration.date_format)))
            else:
                _query_params.append(('deliveryDay', _params['delivery_day']))

        if _params.get('border_direction') is not None:  # noqa: E501
            _query_params.append(('borderDirection', _params['border_direction'].value))

        if _params.get('timescales') is not None:  # noqa: E501
            _query_params.append(('timescales', _params['timescales']))
            _collection_formats['timescales'] = 'multi'

        if _params.get('mtu_size') is not None:  # noqa: E501
            _query_params.append(('mtuSize', _params['mtu_size'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['x_participant_ids']:
            _header_params['X-Participant-Ids'] = _params['x_participant_ids']
            _collection_formats['X-Participant-Ids'] = 'csv'

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKey', 'AuthToken']  # noqa: E501

        _response_types_map = {
            '200': "TransmissionRightsOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/v1/transmission-rights/overview', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
