# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/cli.ipynb (unless otherwise specified).

__all__ = ['deep_animate']

# Cell
import imageio

from skimage import img_as_ubyte
from skimage.transform import resize
from fastscript import call_parse, Param

from .utils import load_checkpoints, animate

import warnings
warnings.filterwarnings("ignore")

# Cell
@call_parse
def deep_animate(source: Param('Path to the source image.', str),
                 driving: Param('Path to the driving video.', str),
                 config: Param('Path to configuration file.', str),
                 checkpoint: Param('Path to model.', str),
                 device: Param('cpu or gpu accelaration', str) = 'cpu',
                 dest: Param('Path to save the generated video.', str) = 'generated_video.mp4',
                 relative: Param('Relative.', bool) = True,
                 adapt_movement_scale: Param('Adaptive moment scale.', bool) = True):

    source_image = imageio.imread(source)
    driving_video = imageio.mimread(driving)

    # resize image and video to 256x256
    source_image = resize(source_image, (256, 256))[..., :3]
    driving_video = [resize(frame, (256, 256))[..., :3] for frame in driving_video]

    generator, kp_detector = load_checkpoints(config_path=config, checkpoint_path=checkpoint)

    predictions = animate(source_image, driving_video, generator, kp_detector, relative=relative,
                          adapt_movement_scale=adapt_movement_scale)

    imageio.mimsave(dest, [img_as_ubyte(frame) for frame in predictions])