"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.stringData = (_b = props.stringData) !== null && _b !== void 0 ? _b : {};
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return { name };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-22.Secret", version: "1.0.0-beta.142" };
//# sourceMappingURL=data:application/json;base64,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