from ichingpy.enum.mixed_enum import MixEnum

# Class-level mapping for "generates", Enum does not allow for ClassVar...
GENERATE_MAPPING: dict[str, str] = {
    "WOOD": "FIRE",
    "FIRE": "EARTH",
    "EARTH": "METAL",
    "METAL": "WATER",
    "WATER": "WOOD",
}


OVERCOME_MAPPING: dict[str, str] = {
    "WOOD": "EARTH",
    "FIRE": "METAL",
    "EARTH": "WATER",
    "METAL": "WOOD",
    "WATER": "FIRE",
}


class FivePhase(MixEnum):
    """The FivePhases (五行) Enum class."""

    METAL = 1, "金"
    WOOD = 2, "木"
    WATER = 3, "水"
    FIRE = 4, "火"
    EARTH = 5, "土"

    @property
    def generates(self) -> "FivePhase":
        """Return the phase generated by this phase."""
        return FivePhase[GENERATE_MAPPING[self.name]]

    @property
    def generated_by(self):
        """Return the phase that generates this phase."""
        # Reverse the generates_mapping
        reverse_mapping = {v: k for k, v in GENERATE_MAPPING.items()}
        return FivePhase[reverse_mapping[self.name]]

    @property
    def overcomes(self) -> "FivePhase":
        """Return the phase that overcomes this phase."""
        return FivePhase[OVERCOME_MAPPING[self.name]]

    @property
    def overcome_by(self) -> "FivePhase":
        """Return the phase that is overcome by this phase."""
        # Reverse the overcomes_mapping
        reverse_mapping = {v: k for k, v in OVERCOME_MAPPING.items()}
        return FivePhase[reverse_mapping[self.name]]
