# coding: utf-8

"""
    Empire - Platform API

    OpenAPI specification for the Platform REST API of Empire  **System Time:** Europe/Amsterdam  **General data formats:**   * _capacity values_ => kW (integers)   * _dates and local times_ => System Time   * _currencies_ => EUR   # noqa: E501

    The version of the OpenAPI document: 0.178.0
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr, validator
from empire_platform_api_public_client.models.address import Address
from empire_platform_api_public_client.models.finance_information_bank_deposits_inner import FinanceInformationBankDepositsInner
from empire_platform_api_public_client.models.finance_information_letter_of_credits_inner import FinanceInformationLetterOfCreditsInner
from empire_platform_api_public_client.models.finance_information_market_vat_details import FinanceInformationMarketVatDetails
from empire_platform_api_public_client.models.finance_information_sage_settings import FinanceInformationSageSettings

class FinanceInformation(BaseModel):
    """
    FinanceInformation
    """
    sage_settings: Optional[FinanceInformationSageSettings] = Field(None, alias="sageSettings")
    billing_address: Optional[Address] = Field(None, alias="billingAddress")
    billing_email: Optional[constr(strict=True)] = Field(None, alias="billingEmail")
    vat_details: conlist(FinanceInformationMarketVatDetails) = Field(..., alias="vatDetails")
    letter_of_credits: conlist(FinanceInformationLetterOfCreditsInner) = Field(..., alias="letterOfCredits")
    bank_deposits: conlist(FinanceInformationBankDepositsInner) = Field(..., alias="bankDeposits")
    __properties = ["sageSettings", "billingAddress", "billingEmail", "vatDetails", "letterOfCredits", "bankDeposits"]

    # @validator('billing_email')
    def billing_email_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$", value):
            raise ValueError(r"must validate the regular expression /^[\w-\.]+@([\w-]+\.)+[\w-]{2,6}$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FinanceInformation:
        """Create an instance of FinanceInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of sage_settings
        if self.sage_settings:
            _dict['sageSettings'] = self.sage_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billingAddress'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vat_details (list)
        _items = []
        if self.vat_details:
            for _item in self.vat_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['vatDetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in letter_of_credits (list)
        _items = []
        if self.letter_of_credits:
            for _item in self.letter_of_credits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['letterOfCredits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bank_deposits (list)
        _items = []
        if self.bank_deposits:
            for _item in self.bank_deposits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bankDeposits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FinanceInformation:
        """Create an instance of FinanceInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FinanceInformation.parse_obj(obj)

        _obj = FinanceInformation.parse_obj({
            "sage_settings": FinanceInformationSageSettings.from_dict(obj.get("sageSettings")) if obj.get("sageSettings") is not None else None,
            "billing_address": Address.from_dict(obj.get("billingAddress")) if obj.get("billingAddress") is not None else None,
            "billing_email": obj.get("billingEmail"),
            "vat_details": [FinanceInformationMarketVatDetails.from_dict(_item) for _item in obj.get("vatDetails")] if obj.get("vatDetails") is not None else None,
            "letter_of_credits": [FinanceInformationLetterOfCreditsInner.from_dict(_item) for _item in obj.get("letterOfCredits")] if obj.get("letterOfCredits") is not None else None,
            "bank_deposits": [FinanceInformationBankDepositsInner.from_dict(_item) for _item in obj.get("bankDeposits")] if obj.get("bankDeposits") is not None else None
        })
        return _obj

